/*
 * Decompiled with CFR 0.152.
 */
package menu;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import menu.Menu;

public class BCLMenu
implements Menu {
    private List<MenuEntry> entries = new ArrayList<MenuEntry>();
    private int maxCommandWidth = 0;

    public BCLMenu(Scanner sin) {
        while (sin.hasNextLine()) {
            String command = sin.nextLine().trim();
            String description = sin.nextLine().trim();
            String help = sin.nextLine().trim();
            this.add(command, description, help);
        }
    }

    public BCLMenu(InputStream in) {
        this(new Scanner(in));
    }

    private void add(String command, String description, String help) {
        this.maxCommandWidth = Math.max(this.maxCommandWidth, command.length());
        this.entries.add(new MenuEntry(command, description, help));
    }

    @Override
    public void display() {
        for (MenuEntry entry : this.entries) {
            System.out.println(entry.menuText());
        }
    }

    @Override
    public void help() {
        for (MenuEntry entry : this.entries) {
            System.out.println(entry.helpText(this.maxCommandWidth));
        }
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public boolean containsCommand(String couldBeACommand) {
        boolean contains = false;
        for (MenuEntry entry : this.entries) {
            contains = contains || entry.command.equals(couldBeACommand);
        }
        return contains;
    }

    @Override
    public String match(String prompt, Scanner keyboard) {
        this.display();
        boolean matched = false;
        String command = "";
        while (!matched) {
            System.out.print(prompt);
            command = keyboard.nextLine().trim();
            if (command.isEmpty() || (matched = this.containsCommand(command))) continue;
            if (command.equals("?")) {
                this.help();
                continue;
            }
            System.out.printf("Unknown menu command '%s'\n", command);
        }
        return command;
    }

    class MenuEntry {
        String command;
        String description;
        String help;

        public MenuEntry(String command, String description, String help) {
            this.command = command;
            this.description = description;
            this.help = help;
        }

        public String menuText() {
            return String.format("%s - %s", this.command, this.description);
        }

        public String helpText(int indent) {
            String fmt = "%" + indent + "s - %s\n%" + indent + "s   %s";
            return String.format(fmt, this.command, this.description, " ", this.help);
        }
    }
}

