/*
 * Decompiled with CFR 0.152.
 */
package arena;

import critters.Critter;
import critters.Fighter;
import critters.Wizard;
import java.util.Random;

public class Battle {
    private Random rng = new Random();

    public int threeD6() {
        return this.rng.nextInt(1, 7) + this.rng.nextInt(1, 7) + this.rng.nextInt(1, 7);
    }

    public Critter critterFactory(String name, Random rng) {
        Critter newCritter = null;
        int die = rng.nextInt(1, 100);
        newCritter = die < 34 ? new Fighter(name, this.threeD6(), this.threeD6(), this.threeD6()) : (die < 67 ? new Wizard(name, this.threeD6(), this.threeD6(), this.threeD6()) : new Wizard(name, this.threeD6(), this.threeD6(), this.threeD6()));
        return newCritter;
    }

    public void run() {
        Critter critterA = this.critterFactory("Eric the Tan", this.rng);
        Critter critterB = this.critterFactory("Guldorn the Clumsy", this.rng);
        System.out.println("Let's Get Ready to Rumble!");
        System.out.println(critterA);
        System.out.println("versus");
        System.out.println(critterB);
        while (critterA.isAlive() && critterB.isAlive()) {
            int damage;
            int coin = this.rng.nextInt(1, 21);
            Critter first = critterA;
            Critter second = critterB;
            if (coin > 10) {
                first = critterB;
                second = critterA;
            }
            System.out.printf("%s attacks %s ", first.getName(), second.getName());
            if (first.attack(second, this.rng)) {
                damage = first.doDamage(second, this.rng);
                System.out.printf("and HITS for %d points\n", damage);
            } else {
                System.out.printf("and misses\n", new Object[0]);
            }
            if (!second.isAlive()) continue;
            System.out.printf("%s attacks %s ", second.getName(), first.getName());
            if (second.attack(first, this.rng)) {
                damage = second.doDamage(first, this.rng);
                System.out.printf("and HITS for %d points\n", damage);
                continue;
            }
            System.out.printf("and misses\n", new Object[0]);
        }
        if (critterA.isAlive()) {
            System.out.printf("%s drops %s, winning the battle.\n", critterA.getName(), critterB.getName());
        } else if (critterB.isAlive()) {
            System.out.printf("%s drops %s, winning the battle.\n", critterB.getName(), critterA.getName());
        } else {
            System.out.println("Both heroes died!");
        }
    }

    public static void main(String[] args) {
        Battle battle = new Battle();
        battle.run();
    }
}

