/*
 * Decompiled with CFR 0.152.
 */
package tree;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Scanner;
import tree.Tree;

public class Countries {
    private Tree<Country> tree;
    private String fileName;

    public Countries(String fileName) {
        this.fileName = fileName;
        this.tree = new Tree();
    }

    public void readAFileOfCountries(String fname) {
        try {
            Scanner fin = new Scanner(new File(fname));
            while (fin.hasNextLine()) {
                String line = fin.nextLine();
                if (line.isBlank()) continue;
                System.out.println(String.format("line: %s", line));
                String[] parts = line.split("\\|");
                this.tree.add(new Country(parts[1].strip(), parts[0].strip()));
            }
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
            System.exit(2);
        }
    }

    public void run() {
        this.readAFileOfCountries(this.fileName);
        System.out.println(this.tree);
    }

    public static void main(String[] args) {
        Countries main = new Countries(args[0]);
        main.run();
    }

    class Country
    implements Comparable {
        String name;
        String continent;

        public Country(String name, String continent) {
            this.name = name;
            this.continent = continent;
        }

        public int compareTo(Object other) {
            if (other instanceof Country) {
                return this.name.compareTo(((Country)other).name);
            }
            return -1;
        }

        public String toString() {
            return this.continent + " | " + this.name;
        }
    }
}

