/*
 * Decompiled with CFR 0.152.
 */
package tree;

public class Tree<E extends Comparable> {
    TreeNode root = null;

    public int numberOfNodes() {
        return this.numberOfNodes(this.root);
    }

    private int numberOfNodes(TreeNode curr) {
        int retval = 0;
        if (curr != null) {
            retval = 1 + this.numberOfNodes(curr.left) + this.numberOfNodes(curr.right);
        }
        return retval;
    }

    public int height() {
        return this.height(this.root);
    }

    private int height(TreeNode curr) {
        int retval = 0;
        if (curr != null) {
            retval = 1 + Math.max(this.height(curr.left), this.height(curr.right));
        }
        return retval;
    }

    private TreeNode biggest(TreeNode curr) {
        if (curr == null) {
            return null;
        }
        if (curr.right == null) {
            return curr;
        }
        return this.biggest(curr.right);
    }

    private TreeNode smallest(TreeNode curr) {
        if (curr == null) {
            return null;
        }
        if (curr.left == null) {
            return curr;
        }
        return this.smallest(curr.left);
    }

    public void delete(E victim) {
        this.root = this.delete(this.root, victim);
    }

    private TreeNode delete(TreeNode curr, E victim) {
        TreeNode retval = curr;
        if (curr == null) {
            return null;
        }
        int relation = curr.data.compareTo(victim);
        if (relation > 0) {
            curr.left = this.delete(curr.left, victim);
        } else if (relation < 0) {
            curr.right = this.delete(curr.right, victim);
        } else if (curr.right == null) {
            retval = curr.left;
        } else if (curr.left == null) {
            retval = curr.right;
        } else {
            TreeNode s = this.smallest(curr.right);
            curr.data = s.data;
            curr.right = this.delete(curr.right, s.data);
        }
        return retval;
    }

    private TreeNode find(TreeNode curr, E match) {
        if (curr == null) {
            return null;
        }
        if (curr.data.compareTo(match) == 0) {
            return curr;
        }
        if (curr.data.compareTo(match) < 0) {
            return this.find(curr.right, match);
        }
        return this.find(curr.left, match);
    }

    public void add(E str) {
        this.root = this.add(this.root, str);
    }

    private TreeNode add(TreeNode curr, E str) {
        if (curr == null) {
            return new TreeNode(this, str);
        }
        if (curr.data.compareTo(str) < 0) {
            curr.right = this.add(curr.right, str);
        } else {
            curr.left = this.add(curr.left, str);
        }
        return curr;
    }

    private String print(TreeNode curr, String indent) {
        if (curr == null) {
            return "";
        }
        Object retval = this.print(curr.left, indent + "  ");
        retval = (String)retval + indent + curr.data + "\n";
        retval = (String)retval + this.print(curr.right, indent + "  ");
        return retval;
    }

    public String toString() {
        return this.print(this.root, "");
    }

    static class TreeNode {
        E data;
        TreeNode left;
        TreeNode right;
        final /* synthetic */ Tree this$0;

        TreeNode(E data, TreeNode left, TreeNode right) {
            this.this$0 = this$0;
            this.data = data;
            this.left = left;
            this.right = right;
        }

        TreeNode(E data) {
            this(this$0, (Comparable)data, null, null);
        }
    }
}

