/*
 * Decompiled with CFR 0.152.
 */
package cpu;

import java.util.ArrayDeque;
import java.util.Queue;
import java.util.Scanner;

public class Simulation {
    private Queue<String> userEntries = new ArrayDeque<String>();

    public void commandLoop() {
        Scanner keyboard = new Scanner(System.in);
        System.out.println("Q command: ");
        while (keyboard.hasNextLine()) {
            String line = keyboard.nextLine();
            if (line.isBlank()) continue;
            Scanner lineScanner = new Scanner(line.strip());
            String cmd = lineScanner.next();
            if ("enqueue".startsWith(cmd)) {
                String whatToEnqueue = lineScanner.nextLine();
                whatToEnqueue = whatToEnqueue.strip();
                this.userEntries.add(whatToEnqueue);
                System.out.println(String.format("Enqueued \"%s\"", whatToEnqueue));
                continue;
            }
            if ("dequeue".startsWith(cmd)) {
                if (!this.userEntries.isEmpty()) {
                    String whatWasDequeued = this.userEntries.poll();
                    System.out.println(String.format("Dequeued \"%s\"", whatWasDequeued));
                    continue;
                }
                System.out.println("There is noting in the queue to dequeue.");
                continue;
            }
            if ("peek".startsWith(cmd)) {
                if (!this.userEntries.isEmpty()) {
                    String peekAtHead = this.userEntries.peek();
                    System.out.println(String.format("Head of list = \"%s\"", peekAtHead));
                    continue;
                }
                System.out.println("There is noting in the queue to peek at.");
                continue;
            }
            if (!"quit".startsWith(cmd)) continue;
            break;
        }
    }

    public int dumpLeftovers() {
        int leftoverElements = 0;
        while (!this.userEntries.isEmpty()) {
            String whatWasDequeued = this.userEntries.poll();
            System.out.println(String.format("\"%s\"", whatWasDequeued));
            ++leftoverElements;
        }
        return leftoverElements;
    }

    public void run() {
        this.commandLoop();
        System.out.println("Leftover Elements");
        int leftoverElements = this.dumpLeftovers();
        System.out.println(String.format("There were %d leftover elements.", leftoverElements));
    }

    public static void main(String[] args) {
        Simulation simulation = new Simulation();
        simulation.run();
    }
}

