/*
 * Decompiled with CFR 0.152.
 */
package tree;

import visitor.Visitor;

public class Tree {
    Node root = null;

    public void add(String newbie) {
        if (this.root == null) {
            this.root = new Node(newbie);
        } else {
            this.add(this.root, newbie);
        }
    }

    private void add(Node curr, String newbie) {
        if (curr.data.compareTo(newbie) < 0) {
            if (curr.right == null) {
                curr.right = new Node(newbie);
            } else {
                this.add(curr.right, newbie);
            }
        } else if (curr.left == null) {
            curr.left = new Node(newbie);
        } else {
            this.add(curr.left, newbie);
        }
    }

    public void inOrder(Visitor iO) {
        this.inOrder(this.root, iO);
    }

    private void inOrder(Node curr, Visitor iO) {
        if (curr != null) {
            this.inOrder(curr.left, iO);
            iO.apply(curr.data);
            this.inOrder(curr.right, iO);
        }
    }

    public void preOrder(Visitor preO) {
        this.preOrder(this.root, preO);
    }

    private void preOrder(Node curr, Visitor preO) {
        if (curr != null) {
            preO.apply(curr.data);
            this.preOrder(curr.left, preO);
            this.preOrder(curr.right, preO);
        }
    }

    class Node {
        String data;
        Node left;
        Node right;

        Node(String data, Node left, Node right) {
            this.data = data;
            this.left = left;
            this.right = right;
        }

        Node(String data) {
            this(data, null, null);
        }
    }
}

