/*
 * Decompiled with CFR 0.152.
 */
package sundae;

import java.util.Scanner;
import sundae.FrozenTreat;
import sundae.FrozenYoghurt;
import sundae.IceCream;
import sundae.Sundae;

public class Receipt {
    Node head = null;

    public FrozenTreat nextFrozenTreat(Scanner fin) {
        String line = fin.nextLine();
        Scanner lineScanner = new Scanner(line = line.trim());
        String treatType = lineScanner.next();
        if (treatType.equals("IceCream")) {
            String flavor = lineScanner.next();
            return new IceCream(flavor);
        }
        if (treatType.equals("FrozenYoghurt")) {
            String flavor = lineScanner.next();
            return new FrozenYoghurt(flavor);
        }
        if (treatType.equals("Sundae")) {
            String topping = lineScanner.next();
            FrozenTreat base = this.nextFrozenTreat(fin);
            return new Sundae(topping, base);
        }
        return null;
    }

    public Receipt(Scanner fin) {
        while (fin.hasNextLine()) {
            FrozenTreat treat = this.nextFrozenTreat(fin);
            this.head = this.add(this.head, treat);
        }
    }

    private Node add(Node curr, FrozenTreat treat) {
        if (curr == null) {
            return new Node(this, treat);
        }
        curr.next = this.add(curr.next, treat);
        return curr;
    }

    public double total() {
        double t = 0.0;
        Node curr = this.head;
        while (curr != null) {
            t += curr.treat.price();
            curr = curr.next;
        }
        return t;
    }

    public String toString() {
        Object receiptString = "";
        String separator = "";
        Node curr = this.head;
        while (curr != null) {
            receiptString = (String)receiptString + separator + String.valueOf(curr.treat);
            separator = "\n";
            curr = curr.next;
        }
        return receiptString;
    }

    class Node {
        FrozenTreat treat;
        Node next;

        public Node(Receipt this$0, FrozenTreat treat, Node next) {
            this.treat = treat;
            this.next = next;
        }

        public Node(Receipt this$0, FrozenTreat treat) {
            this(this$0, treat, null);
        }
    }
}

