/*
 * Decompiled with CFR 0.152.
 */
package scoopdogg;

import frozen.Receipt;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

public class ScoopDogg {
    private String receiptFileName;
    private List<Receipt> allReceipts;

    public ScoopDogg(String receiptFileName) {
        this.receiptFileName = receiptFileName;
    }

    public void run() {
        try {
            System.out.println(String.format("Opening Receipt File %s for input", this.receiptFileName));
            FileInputStream fileInputStream = new FileInputStream(this.receiptFileName);
            Scanner scanner = new Scanner(fileInputStream);
            this.allReceipts = new ArrayList<Receipt>();
            int rCount = 0;
            scanner.useDelimiter("\\|end_receipt\\|\n");
            while (scanner.hasNext()) {
                System.out.println(String.format("Processing Receipt #%d", rCount++));
                String nextReceiptString = scanner.next();
                Scanner receiptScanner = new Scanner(nextReceiptString);
                Receipt nextReceipt = new Receipt(receiptScanner);
                this.allReceipts.add(nextReceipt);
            }
            double totalSales = 0.0;
            for (int i = 0; i < this.allReceipts.size(); ++i) {
                Receipt receipt = this.allReceipts.get(i);
                System.out.println(String.format("%s\nTotal: $%5.2f\n", receipt, receipt.total()));
                totalSales += receipt.total();
            }
            System.out.println(String.format("Store total sales: $%7.2f", totalSales));
        }
        catch (FileNotFoundException e) {
            System.out.println("Error " + e.getMessage());
            e.printStackTrace();
            System.exit(2);
        }
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("Usage: PointOfSale <receiptFilePath>");
            System.exit(2);
        }
        ScoopDogg store = new ScoopDogg(args[0]);
        store.run();
    }
}

