/*
 * Decompiled with CFR 0.152.
 */
package critters;

import java.util.Random;

public class Attribute {
    public static final int SUCCESS_VALUE = 10;
    private Type type;
    private int base;
    private int up;
    private int down;

    public Attribute(Type type, int base) {
        this.type = type;
        this.base = base;
        this.up = 0;
        this.down = 0;
    }

    public int current() {
        return this.base + this.up + this.down;
    }

    public int nerf(int amount) {
        this.down -= amount;
        return this.current();
    }

    public int buff(int amount) {
        this.up += amount;
        return this.current();
    }

    public int heal(int amount) {
        this.down = Math.min(0, this.down + amount);
        return this.current();
    }

    public int deBuff(int amount) {
        this.down = Math.max(0, this.up - amount);
        return this.current();
    }

    public int nerfTotal() {
        return -this.down;
    }

    public int buffTotal() {
        return this.up;
    }

    public int level(int amount) {
        this.base += amount;
        return this.current();
    }

    public int deBuffAll() {
        this.deBuff(this.buffTotal());
        return this.current();
    }

    public int healAll() {
        this.heal(this.nerfTotal());
        return this.current();
    }

    public boolean challenge(Attribute opposingAttribute, int delta, Random random) {
        int opposition;
        int die = random.nextInt(1, 21);
        int attempt = die + this.current();
        return attempt - (opposition = opposingAttribute.current()) >= 10;
    }

    public boolean challenge(Attribute opposingAttribute, Random random) {
        return this.challenge(opposingAttribute, 0, random);
    }

    public String toString() {
        return String.format("%s: %d (+%d/-%d)", this.type.toString(), this.current(), this.buffTotal(), this.nerfTotal());
    }

    public static enum Type {
        STR,
        DEX,
        INT,
        HP;

    }
}

