/*
 * Decompiled with CFR 0.152.
 */
package token;

public class Tokenizer {
    private String content;
    private int start;
    private int end;

    public Tokenizer(String content) {
        this.content = content;
        this.start = 0;
        this.end = 0;
        this.advance();
    }

    private void advance() {
        if (this.hasNextToken()) {
            while (this.end < this.content.length() && Character.isWhitespace(this.content.charAt(this.end))) {
                ++this.end;
            }
            this.start = this.end;
            if (this.end < this.content.length() && Character.isDigit(this.content.charAt(this.start))) {
                while (this.end < this.content.length() && Character.isDigit(this.content.charAt(this.end))) {
                    ++this.end;
                }
            } else {
                this.end = this.start + 1;
            }
        }
    }

    public boolean hasNextToken() {
        return this.start < this.content.length();
    }

    public String nextToken() {
        if (!this.hasNextToken()) {
            return null;
        }
        String token = this.content.substring(this.start, this.end);
        this.advance();
        return token;
    }

    public String peekToken() {
        if (!this.hasNextToken()) {
            return null;
        }
        return this.content.substring(this.start, this.end);
    }
}

