/*
 * Decompiled with CFR 0.152.
 */
package bits;

public class BitString {
    public static final BitString one = new BitString(1);
    public static final BitString zero = new BitString();
    public static final BitString negativeOne = new BitString(-1);
    protected static final int WIDTH = 16;
    protected char[] str = new char[16];

    public BitString(String s) {
        for (int i = 16; i > 0; --i) {
            int j = i - 1;
            int k = 16 - i;
            this.str[j] = s.charAt(k);
        }
    }

    public BitString(short v) {
        for (int i = 0; i < 16; ++i) {
            this.str[i] = (char)(48 + (v & 1));
            v = (short)(v >> 1);
        }
    }

    public BitString() {
        this(0);
    }

    public BitString(BitString other) {
        for (int i = 0; i < 16; ++i) {
            this.str[i] = other.str[i];
        }
    }

    public int toInt() {
        int value = 0;
        for (int i = 16; i > 0; --i) {
            int j = i - 1;
            value = value * 2 + (this.str[j] - 48);
        }
        return value;
    }

    public short toShort() {
        return (short)this.toInt();
    }

    public String stringOfZeroesAndOnes() {
        Object retval = "";
        for (int i = 16; i > 0; --i) {
            int j = i - 1;
            retval = (String)retval + this.str[j];
        }
        return retval;
    }

    public String toString() {
        String withoutSpaces = this.stringOfZeroesAndOnes();
        Object retval = withoutSpaces.substring(0, 4);
        withoutSpaces = withoutSpaces.substring(4);
        while (!withoutSpaces.isEmpty()) {
            retval = (String)retval + " " + withoutSpaces.substring(0, 4);
            withoutSpaces = withoutSpaces.substring(4);
        }
        return retval;
    }

    public void addInPlace(BitString rhs) {
        int carry = 0;
        for (int i = 0; i < 16; ++i) {
            int count = this.str[i] - 48 + (rhs.str[i] - 48) + carry;
            this.str[i] = (count & 1) == 1 ? 49 : 48;
            carry = count >> 1;
        }
    }

    public void andInPlace(BitString rhs) {
        for (int i = 0; i < 16; ++i) {
            this.str[i] = this.str[i] == '1' && rhs.str[i] == '1' ? 49 : 48;
        }
    }

    public void decrementInPlace(short d) {
        BitString bits = new BitString(d);
        bits.invertInPlace();
        bits.addInPlace(one);
        this.addInPlace(bits);
    }

    public void decrementInPlace() {
        this.decrementInPlace((short)1);
    }

    public void incrementInPlace(short d) {
        BitString bits = new BitString(d);
        this.addInPlace(bits);
    }

    public void incrementInPlace() {
        this.incrementInPlace((short)1);
    }

    public void invertInPlace() {
        for (int i = 0; i < 16; ++i) {
            this.str[i] = (char)(1 - (this.str[i] - 48) + 48);
        }
    }

    public void orInPlace(BitString rhs) {
        for (int i = 0; i < 16; ++i) {
            this.str[i] = this.str[i] == '0' && rhs.str[i] == '0' ? 48 : 49;
        }
    }

    public void xorInPlace(BitString rhs) {
        for (int i = 0; i < 16; ++i) {
            this.str[i] = this.str[i] != rhs.str[i] ? 49 : 48;
        }
    }

    public BitString add(BitString rhs) {
        BitString result = new BitString(rhs);
        result.addInPlace(this);
        return result;
    }

    public BitString and(BitString rhs) {
        BitString result = new BitString(rhs);
        result.andInPlace(this);
        return result;
    }

    public BitString decrement(short d) {
        BitString result = new BitString(this);
        result.decrementInPlace(d);
        return result;
    }

    public BitString decrement() {
        return this.decrement((short)1);
    }

    public BitString increment(short d) {
        BitString result = new BitString(this);
        result.incrementInPlace(d);
        return result;
    }

    public BitString increment() {
        return this.increment((short)1);
    }

    public BitString invert() {
        BitString result = new BitString(this);
        result.invertInPlace();
        return result;
    }

    public BitString or(BitString rhs) {
        BitString result = new BitString(rhs);
        result.orInPlace(this);
        return result;
    }

    public BitString xor(BitString rhs) {
        BitString result = new BitString(rhs);
        result.xorInPlace(this);
        return result;
    }

    public boolean negative() {
        return this.str[15] == '1';
    }

    public boolean zero() {
        boolean isZero = true;
        for (char ch : this.str) {
            isZero = isZero && ch == '0';
        }
        return isZero;
    }
}

