/*
 * Decompiled with CFR 0.152.
 */
package bits;

import bits.Instruction;
import java.util.Map;
import java.util.stream.Collectors;

public class InstructionToASM {
    private static final Map<String, String> JMP2Bits = Map.ofEntries(Map.entry("", "000"), Map.entry("JGT", "001"), Map.entry("JEQ", "010"), Map.entry("JGE", "011"), Map.entry("JLT", "100"), Map.entry("JNE", "101"), Map.entry("JLE", "110"), Map.entry("JMP", "111"));
    private static final Map<String, String> Bits2JMP = JMP2Bits.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey, (oldValue, newValue) -> oldValue));
    private static final Map<String, String> DST2Bits = Map.ofEntries(Map.entry("", "000"), Map.entry("M", "001"), Map.entry("D", "010"), Map.entry("MD", "011"), Map.entry("A", "100"), Map.entry("AM", "101"), Map.entry("AD", "110"), Map.entry("AMD", "111"));
    private static final Map<String, String> Bits2DST = DST2Bits.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey, (oldValue, newValue) -> oldValue));
    private static final Map<String, String> ASM2Bits = Map.ofEntries(Map.entry("0", "0101010"), Map.entry("1", "0111111"), Map.entry("-1", "0111010"), Map.entry("D", "0001100"), Map.entry("A", "0110000"), Map.entry("M", "1110000"), Map.entry("!D", "0001101"), Map.entry("!A", "0110001"), Map.entry("!M", "1110001"), Map.entry("-D", "0001111"), Map.entry("-A", "0110011"), Map.entry("-M", "1110011"), Map.entry("D+1", "0011111"), Map.entry("A+1", "0110111"), Map.entry("M+1", "1110111"), Map.entry("D-1", "0001110"), Map.entry("A-1", "0110010"), Map.entry("M-1", "1110010"), Map.entry("D+A", "0000010"), Map.entry("D+M", "1000010"), Map.entry("D-A", "0010011"), Map.entry("D-M", "1010011"), Map.entry("A-D", "0000111"), Map.entry("M-D", "1000111"), Map.entry("D&A", "0000000"), Map.entry("D&M", "1000000"), Map.entry("D|A", "0010101"), Map.entry("D|M", "1010101"));
    private static final Map<String, String> Bits2ASM = ASM2Bits.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey, (oldValue, newValue) -> oldValue));

    public static Instruction fromASM(String asm) {
        if (asm.startsWith("@")) {
            return new Instruction(Short.parseShort(asm.substring(1)));
        }
        int equals = asm.indexOf("=");
        String dst = equals >= 0 ? asm.substring(0, equals) : "";
        asm = equals >= 0 ? asm.substring(equals + 1) : asm;
        int semi = asm.indexOf(";");
        String jmp = semi >= 0 ? asm.substring(semi + 1) : "";
        asm = semi >= 0 ? asm.substring(0, semi) : asm;
        String bits = "111" + ASM2Bits.get(asm) + DST2Bits.get(dst) + JMP2Bits.get(jmp);
        return new Instruction(bits);
    }

    private static String acomp(String bits) {
        return bits.substring(3, 10);
    }

    private static String dst(String bits) {
        return bits.substring(10, 13);
    }

    private static String jmp(String bits) {
        return bits.substring(13, 16);
    }

    private static String CInstructionToASM(Instruction instruction) {
        String j;
        String bits = instruction.stringOfZeroesAndOnes();
        Object retval = Bits2ASM.get(InstructionToASM.acomp(bits));
        String d = Bits2DST.get(InstructionToASM.dst(bits));
        if (!d.isEmpty()) {
            retval = d + "=" + (String)retval;
        }
        if (!(j = Bits2JMP.get(InstructionToASM.jmp(bits))).isEmpty()) {
            retval = (String)retval + ";" + j;
        }
        return retval;
    }

    private static String AInstructionToASM(Instruction instruction) {
        return String.format("@%d", instruction.toInt());
    }

    public static String toASM(Instruction instruction) {
        if (instruction.AInstruction()) {
            return InstructionToASM.AInstructionToASM(instruction);
        }
        return InstructionToASM.CInstructionToASM(instruction);
    }
}

