/*
 * Decompiled with CFR 0.152.
 */
package hardware;

import bits.BitString;
import bits.Instruction;
import bits.InstructionToASM;
import hardware_interface.InstructionMemory;
import hardware_interface.Memory;
import hardware_interface.N2TCPU;
import util.CSIIILogger;

public class CPU
implements N2TCPU {
    private Memory data;
    private InstructionMemory instructions;
    private CSIIILogger logger;
    private boolean noMoreProgram;
    private BitString D;
    private BitString A;
    private Instruction IDR;
    private BitString PC;

    public CPU(Memory data, InstructionMemory instructions) {
        this.data = data;
        this.instructions = instructions;
        this.noMoreProgram = false;
        this.D = new BitString();
        this.A = new BitString();
        this.PC = new BitString();
        this.IDR = new Instruction();
        this.logger = new CSIIILogger();
    }

    public void setLogger(CSIIILogger logger) {
        this.logger = logger;
    }

    @Override
    public String state() {
        String M_A = "";
        if (this.A.toInt() < this.data.capacity()) {
            M_A = String.format("  M[A] = %s (%d)\n", this.data.get(this.A), this.data.get(this.A).toShort());
        }
        return "CPU State:\n" + String.format("  A    = %s (%d)\n", this.A, this.A.toShort()) + M_A + String.format("  D    = %s (%d)\n", this.D, this.D.toShort()) + String.format("  PC   = %s (%d)\n", this.PC, this.PC.toShort()) + String.format("  IDR  = %s [%s]\n", this.IDR, InstructionToASM.toASM(this.IDR));
    }

    @Override
    public boolean halt() {
        return this.noMoreProgram;
    }

    @Override
    public void fetch() {
        boolean bl = this.noMoreProgram = this.PC.toInt() >= this.instructions.size();
        if (!this.noMoreProgram) {
            this.IDR = this.instructions.get(this.PC);
            this.logger.println(this.getClass().getName(), "fetch", String.format("[%s] %s (%s)", this.PC, this.IDR, InstructionToASM.toASM(this.IDR)));
            this.PC.incrementInPlace();
        }
    }

    @Override
    public void decode() {
    }

    @Override
    public void execute() {
        if (this.IDR.CInstruction()) {
            BitString y;
            BitString x = this.D;
            BitString bitString = y = !this.IDR.a() ? this.A : this.data.get(this.A);
            if (x == null || y == null) {
                System.err.println(String.format("Panic: x = %s, y = %s", x, y));
            }
            if (this.IDR.zx()) {
                x = new BitString();
            }
            if (this.IDR.nx()) {
                x = x.invert();
            }
            if (this.IDR.zy()) {
                y = new BitString();
            }
            if (this.IDR.ny()) {
                y = y.invert();
            }
            BitString out = this.IDR.f() ? x.add(y) : x.and(y);
            if (this.IDR.no()) {
                out = out.invert();
            }
            this.logger.println(this.getClass().getName(), "execute", String.format("out = %s", out));
            if (this.IDR.M()) {
                this.data.set(this.A, out);
            }
            if (this.IDR.A()) {
                this.A = out;
            }
            if (this.IDR.D()) {
                this.D = out;
            }
            if (this.IDR.jump(out.negative(), out.zero())) {
                this.PC = this.A;
            }
        } else if (this.IDR.AInstruction()) {
            this.A = this.IDR;
        }
    }
}

