/*
 * Decompiled with CFR 0.152.
 */
package hardware;

import bits.BitString;
import hardware_interface.Memory;
import java.util.Scanner;
import util.CSIIILogger;

public class RAM
implements Memory {
    public static final int DEFAULT_RAM_SIZE = 32768;
    private int memCapacity;
    private BitString[] backingStore;
    private int memSize;
    CSIIILogger logger;

    public RAM(int capacity) {
        this.memCapacity = capacity;
        this.backingStore = new BitString[this.memCapacity];
        for (int address = 0; address < this.memCapacity; ++address) {
            this.backingStore[address] = new BitString();
        }
        this.memSize = 0;
        this.logger = new CSIIILogger();
    }

    public RAM() {
        this(32768);
    }

    @Override
    public int capacity() {
        return this.memCapacity;
    }

    private void setSize(int maybeSize) {
        this.memSize = Math.max(this.memSize, maybeSize + 1);
    }

    @Override
    public int size() {
        return this.memSize;
    }

    public void setLogger(CSIIILogger logger) {
        this.logger = logger;
    }

    private int validateAddress(BitString address, int max, String functionName) {
        int nAddress = address.toInt();
        if (nAddress >= max) {
            throw new IndexOutOfBoundsException(String.format("%s Bounds Exceeded in %s with %s [%d/%d]", "RAM", functionName, address, nAddress, max));
        }
        this.setSize(nAddress);
        return nAddress;
    }

    private int validateAddress(BitString address, String functionName) {
        return this.validateAddress(address, this.memCapacity, functionName);
    }

    @Override
    public BitString get(BitString address) {
        int validAddress = this.validateAddress(address, "get");
        return this.backingStore[validAddress];
    }

    @Override
    public void set(BitString address, BitString value) {
        int validAddress = this.validateAddress(address, "set");
        this.logger.println(this.getClass().getName(), "set", String.format("[%s] %s -> %s", address, value, this.backingStore[validAddress]));
        this.backingStore[validAddress] = value;
    }

    @Override
    public short fillFromScanner(Scanner fin, BitString startAddress) {
        int addr = startAddress.toInt();
        short wordsRead = 0;
        while (fin.hasNextLine()) {
            String word = fin.nextLine();
            if (word.isBlank()) continue;
            this.backingStore[addr++] = new BitString(word);
            wordsRead = (short)(wordsRead + 1);
        }
        this.setSize(wordsRead);
        return wordsRead;
    }

    @Override
    public short[] rangeToShort(BitString first, BitString last) {
        int nStart = this.validateAddress(first, "rangeToShort");
        int nLast = this.validateAddress(last, "rangeToShort");
        int nSize = nLast - nStart + 1;
        short[] retval = new short[nSize];
        for (int i = 0; i < nSize; ++i) {
            retval[i] = this.backingStore[nStart].toShort();
            ++nStart;
        }
        return retval;
    }

    @Override
    public BitString[] rangeToBitString(BitString first, BitString last) {
        int nStart = this.validateAddress(first, "rangeToBitString");
        int nLast = this.validateAddress(last, "rangeToBitString");
        int nSize = nLast - nStart + 1;
        BitString[] retval = new BitString[nSize];
        for (int i = 0; i < nSize; ++i) {
            retval[i] = this.backingStore[nStart];
            ++nStart;
        }
        return retval;
    }
}

