/*
 * Decompiled with CFR 0.152.
 */
package hardware;

import bits.BitString;
import bits.Instruction;
import bits.InstructionToASM;
import hardware.RAM;
import hardware_interface.InstructionMemory;
import java.util.Scanner;

public class ROM
implements InstructionMemory {
    public static final int DEFAULT_ROM_SIZE = 16384;
    private RAM backingStore;

    public ROM(int size) {
        this.backingStore = new RAM(size);
    }

    public ROM() {
        this(16384);
    }

    @Override
    public int capacity() {
        return this.backingStore.capacity();
    }

    @Override
    public int size() {
        return this.backingStore.size();
    }

    @Override
    public Instruction get(BitString address) {
        BitString word = this.backingStore.get(address);
        return new Instruction(word);
    }

    public void set(BitString address, Instruction vaule) {
    }

    @Override
    public short fillFromScanner(Scanner fin, BitString startAddress) {
        return this.backingStore.fillFromScanner(fin, startAddress);
    }

    public short fillFromASMScanner(Scanner asmFin, BitString startAddress) {
        short wordsRead = 0;
        while (asmFin.hasNextLine()) {
            String word = asmFin.nextLine();
            if (word.isBlank()) continue;
            this.backingStore.set(startAddress, InstructionToASM.fromASM(word));
            startAddress.incrementInPlace();
            wordsRead = (short)(wordsRead + 1);
        }
        return wordsRead;
    }

    @Override
    public short[] rangeToShort(BitString first, BitString last) {
        return this.backingStore.rangeToShort(first, last);
    }

    @Override
    public BitString[] rangeToBitString(BitString first, BitString last) {
        return this.backingStore.rangeToBitString(first, last);
    }

    public Instruction[] rangeToInstruction(BitString first, BitString last) {
        BitString[] words = this.backingStore.rangeToBitString(first, last);
        Instruction[] instructions = new Instruction[words.length];
        int i = 0;
        for (BitString word : words) {
            instructions[i++] = new Instruction(word);
        }
        return instructions;
    }

    public String[] rangeToASM(BitString first, BitString last) {
        Instruction[] instructions = this.rangeToInstruction(first, last);
        String[] asm = new String[instructions.length];
        int i = 0;
        for (Instruction instruction : instructions) {
            asm[i++] = InstructionToASM.toASM(instruction);
        }
        return asm;
    }
}

