/*
 * Decompiled with CFR 0.152.
 */
package simulation;

import bits.BitString;
import bits.Instruction;
import bits.InstructionToASM;
import hardware.CPU;
import hardware.RAM;
import hardware.ROM;
import hardware_interface.InstructionMemory;
import hardware_interface.Memory;
import java.io.FileNotFoundException;

public class CPUClient {
    public static final BitString one = new BitString(1);
    public static final BitString zero = new BitString();
    public static final BitString negativeOne = new BitString(-1);
    private String inputFileName;
    private int cpuStateCount;

    public CPUClient(String fname, int cpu) {
        this.inputFileName = fname;
        this.cpuStateCount = cpu;
    }

    public static void main(String[] args) {
        int cpuStateCount = -1;
        String cpuStateString = "--cpu";
        String fname = "";
        for (int i = 0; i < args.length; ++i) {
            String argument = args[i];
            if (argument.equals(cpuStateString)) {
                String cpu = args[i + 1];
                cpuStateCount = Integer.parseInt(cpu);
                ++i;
                continue;
            }
            fname = argument;
        }
        if (fname.isEmpty()) {
            CPUClient.usage();
            System.exit(1);
        }
        CPUClient cpu = new CPUClient(fname, cpuStateCount);
        cpu.run();
    }

    public static void usage() {
        System.err.println("usage: CPUClient <hackFileName> [--cpu <n>]");
        System.err.println("       where");
        System.err.println("         <hackFileName> - path to a Hack machine language file");
        System.err.println("                          REQUIRED");
        System.err.println("         --cpu <n> - print CPU state every <n> clock cycles;");
        System.err.println("                     optional, defaults to off");
    }

    public void run() {
        ROM theROM = new ROM();
        try {
            theROM.fillFromFile(this.inputFileName);
        }
        catch (FileNotFoundException fnfe) {
            System.err.println(String.format("Cannot open %s for input.", this.inputFileName));
            System.exit(2);
        }
        System.out.println("Loaded Program:");
        System.out.println("   +-----------------------------------+");
        this.displayProgram(theROM);
        System.out.println("   +-----------------------------------+");
        System.out.println();
        RAM theRAM = new RAM();
        CPU cpu = new CPU(theRAM, theROM);
        int clock = 0;
        if (this.cpuStateCount > 0) {
            System.out.println(String.format("Before clock cycle %d:", clock));
            System.out.println(cpu.state());
        }
        cpu.fetch();
        while (!cpu.halt()) {
            cpu.decode();
            cpu.execute();
            if (this.cpuStateCount > 0 && ++clock % this.cpuStateCount == 0) {
                System.out.println(String.format("Before clock cycle %d:", clock));
                System.out.println(cpu.state());
            }
            cpu.fetch();
        }
        System.out.println("Modified RAM:");
        System.out.println("   +-----------------------------------+");
        this.displayData(theRAM);
        System.out.println("   +-----------------------------------+");
    }

    private void displayProgram(InstructionMemory rom) {
        int lastValidIndex = rom.size() - 1;
        BitString[] bitstrings = rom.rangeToBitString(zero, new BitString((short)lastValidIndex));
        for (int address = 0; address < bitstrings.length; ++address) {
            Instruction instruction = new Instruction(bitstrings[address]);
            System.out.println(String.format("[%d] %s : %s", address, instruction, InstructionToASM.toASM(instruction)));
        }
    }

    private void displayData(Memory ram) {
        int lastValidIndex = ram.size() - 1;
        System.out.println(String.format("lastValidIndex = %d", lastValidIndex));
        BitString[] bitstrings = ram.rangeToBitString(zero, new BitString((short)lastValidIndex));
        for (int address = 0; address < bitstrings.length; ++address) {
            BitString bits = bitstrings[address];
            System.out.println(String.format("[%d] %s : %d", address, bits, bits.toShort()));
        }
    }
}

