/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

public class CSIIILogger {
    private static final String DEFAULT_LOG_NAME = "Log";
    private List<PrintStream> logs;
    private String name;
    private boolean logging;

    public CSIIILogger(String name) {
        this.name = name;
        this.logs = new ArrayList<PrintStream>();
        this.logging = true;
    }

    public CSIIILogger() {
        this(DEFAULT_LOG_NAME);
        this.off();
    }

    public CSIIILogger(PrintStream log) {
        this();
        this.logs.add(log);
    }

    public CSIIILogger(String name, PrintStream log) {
        this(name);
        this.logs.add(log);
    }

    public void add(PrintStream logOut) {
        this.logs.add(logOut);
    }

    public void remove(PrintStream logOut) {
        this.logs.remove(logOut);
    }

    public void on() {
        this.logging = true;
    }

    public void off() {
        this.logging = false;
    }

    public boolean toggle() {
        this.logging = !this.logging;
        return this.logging;
    }

    private void _entering(String className, String methodName) {
        for (PrintStream log : this.logs) {
            log.printf("%s: entering %s.%s\n", this.name, className, methodName);
        }
    }

    public void entering(String className, String methodName) {
        if (this.logging) {
            this._entering(className, methodName);
        }
    }

    private void _exiting(String className, String methodName) {
        for (PrintStream log : this.logs) {
            log.printf("%s: exiting %s.%s\n", this.name, className, methodName);
        }
    }

    public void exiting(String className, String methodName) {
        if (this.logging) {
            this._exiting(className, methodName);
        }
    }

    private void _println(String className, String methodName, String message) {
        for (PrintStream log : this.logs) {
            log.printf("%s: %s.%s - %s\n", this.name, className, methodName, message);
        }
    }

    public void println(String className, String methodName, String message) {
        if (this.logging) {
            this._println(className, methodName, message);
        }
    }
}

