/*
 * Decompiled with CFR 0.152.
 */
package client;

import bits.BitString;
import bits.Instruction;

public class InstructionDriver {
    private String instruction;
    private String xWire;
    private String yWire;

    public InstructionDriver(String ins, String x, String y) {
        this.instruction = ins;
        this.xWire = x;
        this.yWire = y;
    }

    public void run() {
        Instruction ins = new Instruction(this.instruction);
        BitString x = new BitString(this.xWire);
        BitString y = new BitString(this.yWire);
        System.out.println(String.format("ins: %s", ins));
        System.out.println(String.format("x:   %s(%d)", x, x.toShort()));
        System.out.println(String.format("y:   %s(%d)", y, y.toShort()));
        if (ins.CInstruction()) {
            if (ins.a()) {
                System.out.println("Addressing Memory, not Register A");
            }
            if (ins.zx()) {
                x = new BitString();
            }
            if (ins.nx()) {
                x = x.invert();
            }
            if (ins.zy()) {
                y = new BitString();
            }
            if (ins.ny()) {
                y = y.invert();
            }
            BitString out = ins.f() ? x.add(y) : x.and(y);
            if (ins.no()) {
                out = out.invert();
            }
            System.out.println(String.format("out: %s(%d)", out, out.toShort()));
            System.out.print("Storing to: ");
            if (ins.A()) {
                System.out.print("A");
            }
            if (ins.D()) {
                System.out.print("D");
            }
            if (ins.M()) {
                System.out.print("M");
            }
            System.out.println();
            System.out.print("Jump on: ");
            if (ins.JLesser()) {
                System.out.print("<");
            }
            if (ins.JEqual()) {
                System.out.print("=");
            }
            if (ins.JGreater()) {
                System.out.print(">");
            }
            System.out.println();
        } else if (ins.AInstruction()) {
            System.out.println("An A instruction");
            System.out.println(String.format("@%d", ins.toShort()));
        }
    }

    public static void main(String[] args) {
        String ins = "1110010011100101";
        String x = "1111111111111111";
        String y = "0000000001100100";
        if (args.length > 0) {
            ins = args[0];
        }
        if (args.length > 1) {
            x = args[1];
        }
        if (args.length > 2) {
            y = args[2];
        }
        InstructionDriver it = new InstructionDriver(ins, x, y);
        it.run();
    }
}

