/*
 * Decompiled with CFR 0.152.
 */
package driver;

import io.LineScanner;
import java.io.FileReader;
import java.io.IOException;

public class LineScannerDriver {
    String fileName;
    LineScanner theLineScanner;

    public LineScannerDriver(String fileName) {
        this.fileName = fileName;
        try {
            this.theLineScanner = new LineScanner(new FileReader(fileName));
        }
        catch (IOException ioe) {
            System.out.println("Error " + ioe.getMessage());
            ioe.printStackTrace();
            System.exit(2);
        }
    }

    public void run() {
        int lineNumber = 0;
        while (this.theLineScanner.hasNextLine()) {
            String line = this.theLineScanner.nextLine();
            System.out.printf("[%d] %s\n", ++lineNumber, line);
        }
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("Must be called with a file name to be echoed.");
            System.exit(1);
        }
        LineScannerDriver linescannerdriver = new LineScannerDriver(args[0]);
        linescannerdriver.run();
    }
}

