/*
 * Decompiled with CFR 0.152.
 */
package calculator;

import expression.BinaryOperatorExpression;
import expression.Expression;
import expression.NumericExpression;
import java.util.Scanner;
import token.Tokenizer;

public class Calculator {
    private Expression Exp(Tokenizer tokenizer) {
        Expression lhs = this.Term(tokenizer);
        while (tokenizer.hasNextToken() && "+-".contains(tokenizer.peekToken())) {
            String op = tokenizer.nextToken();
            Expression rhs = this.Exp(tokenizer);
            lhs = new BinaryOperatorExpression(lhs, op, rhs);
        }
        return lhs;
    }

    private Expression Term(Tokenizer tokenizer) {
        Expression lhs = this.Power(tokenizer);
        while (tokenizer.hasNextToken() && "*/%".contains(tokenizer.peekToken())) {
            String op = tokenizer.nextToken();
            Expression rhs = this.Term(tokenizer);
            lhs = new BinaryOperatorExpression(lhs, op, rhs);
        }
        return lhs;
    }

    private Expression Power(Tokenizer tokenizer) {
        Expression lhs = this.Factor(tokenizer);
        while (tokenizer.hasNextToken() && "^".contains(tokenizer.peekToken())) {
            String op = tokenizer.nextToken();
            Expression rhs = this.Power(tokenizer);
            lhs = new BinaryOperatorExpression(lhs, op, rhs);
        }
        return lhs;
    }

    private Expression Factor(Tokenizer tokenizer) {
        Expression retval = null;
        if (tokenizer.peekToken().equals("(")) {
            tokenizer.nextToken();
            retval = this.Exp(tokenizer);
            if (tokenizer.peekToken().equals(")")) {
                tokenizer.nextToken();
            }
        } else {
            retval = new NumericExpression(tokenizer.nextToken());
        }
        return retval;
    }

    public void run() {
        Scanner keyboard = new Scanner(System.in);
        System.out.print("Expression to evaluate: ");
        while (keyboard.hasNextLine()) {
            String line = keyboard.nextLine();
            if (!(line = line.trim()).isEmpty()) {
                Tokenizer t = new Tokenizer(line);
                Expression e = this.Exp(t);
                System.out.println(String.format("%s = %d", e, e.eval()));
            }
            System.out.print("Expression to evaluate: ");
        }
    }

    public static void main(String[] args) {
        Calculator client = new Calculator();
        client.run();
    }
}

