/*
 * Decompiled with CFR 0.152.
 */
package expression;

import expression.Expression;

public class BinaryOperatorExpression
implements Expression {
    private final Expression lhs;
    private final Expression rhs;
    private final String op;
    int _precedence;

    private static int precedence(String op) {
        switch (op) {
            case "+": 
            case "-": {
                return 1;
            }
            case "*": 
            case "/": 
            case "%": {
                return 2;
            }
            case "^": {
                return 2;
            }
        }
        return 0;
    }

    private static int eval(int left, String op, int right) {
        switch (op) {
            case "+": {
                return left + right;
            }
            case "-": {
                return left - right;
            }
            case "*": {
                return left * right;
            }
            case "/": {
                return left / right;
            }
            case "%": {
                return left % right;
            }
            case "^": {
                int r = 1;
                while (right > 0) {
                    r *= left;
                }
                return r;
            }
        }
        return 0;
    }

    public BinaryOperatorExpression(Expression lhs, String op, Expression rhs) {
        this.lhs = lhs;
        this.op = op;
        this.rhs = rhs;
        this._precedence = BinaryOperatorExpression.precedence(op);
    }

    @Override
    public int eval() {
        int l = this.lhs.eval();
        int r = this.rhs.eval();
        return BinaryOperatorExpression.eval(l, this.op, r);
    }

    @Override
    public String toString() {
        Object left = this.lhs.toString();
        Object right = this.rhs.toString();
        if (this.lhs.precedence() < this._precedence) {
            left = "(" + (String)left + ")";
        }
        if (this.rhs.precedence() < this._precedence) {
            right = "(" + (String)right + ")";
        }
        return String.format("%s %s %s", left, this.op, right);
    }

    @Override
    public int precedence() {
        return this._precedence;
    }
}

