/*
 * Decompiled with CFR 0.152.
 */
package bits;

public class BitString {
    private static final int WIDTH = 16;
    private static final BitString one = new BitString(1);
    private static final BitString negativeOne = new BitString(-1);
    protected char[] str = new char[16];

    public BitString(String s) {
        for (int i = 16; i > 0; --i) {
            int j = i - 1;
            int k = 16 - i;
            this.str[j] = s.charAt(k);
        }
    }

    public BitString(short v) {
        for (int i = 0; i < 16; ++i) {
            this.str[i] = (char)(48 + (v & 1));
            v = (short)(v >> 1);
        }
    }

    public BitString() {
        this(0);
    }

    public BitString(BitString other) {
        for (int i = 0; i < 16; ++i) {
            this.str[i] = other.str[i];
        }
    }

    public int toInt() {
        int value = 0;
        for (int i = 16; i > 0; --i) {
            int j = i - 1;
            value = value * 2 + (this.str[j] - 48);
        }
        return value;
    }

    public short toShort() {
        return (short)this.toInt();
    }

    public String toString() {
        Object retval = "";
        String separator = "";
        for (int i = 16; i > 0; --i) {
            int j = i - 1;
            if (i % 4 == 0) {
                retval = (String)retval + separator;
                separator = " ";
            }
            retval = (String)retval + this.str[j];
        }
        return retval;
    }

    public void andInPlace(BitString rhs) {
        for (int i = 0; i < 16; ++i) {
            this.str[i] = this.str[i] == '1' && rhs.str[i] == '1' ? 49 : 48;
        }
    }

    public void decrementInPlace() {
        this.plusInPlace(negativeOne);
    }

    public void incrementInPlace() {
        this.plusInPlace(one);
    }

    public void invertInPlace() {
        for (int i = 0; i < 16; ++i) {
            this.str[i] = (char)(1 - (this.str[i] - 48) + 48);
        }
    }

    public void orInPlace(BitString rhs) {
        for (int i = 0; i < 16; ++i) {
            this.str[i] = this.str[i] == '0' && rhs.str[i] == '0' ? 48 : 49;
        }
    }

    public void plusInPlace(BitString rhs) {
        int carry = 0;
        for (int i = 0; i < 16; ++i) {
            int count = this.str[i] - 48 + (rhs.str[i] - 48) + carry;
            this.str[i] = (count & 1) == 1 ? 49 : 48;
            carry = count >> 1;
        }
    }

    public void xorInPlace(BitString rhs) {
        for (int i = 0; i < 16; ++i) {
            this.str[i] = this.str[i] != rhs.str[i] ? 49 : 48;
        }
    }

    public BitString and(BitString rhs) {
        BitString result = new BitString(rhs);
        result.andInPlace(this);
        return result;
    }

    public BitString decrement() {
        BitString result = new BitString(this);
        result.decrementInPlace();
        return result;
    }

    public BitString increment() {
        BitString result = new BitString(this);
        result.incrementInPlace();
        return result;
    }

    public BitString invert() {
        BitString result = new BitString(this);
        result.invertInPlace();
        return result;
    }

    public BitString or(BitString rhs) {
        BitString result = new BitString(rhs);
        result.orInPlace(this);
        return result;
    }

    public BitString plus(BitString rhs) {
        BitString result = new BitString(rhs);
        result.plusInPlace(this);
        return result;
    }

    public BitString xor(BitString rhs) {
        BitString result = new BitString(rhs);
        result.xorInPlace(this);
        return result;
    }

    public boolean negative() {
        return this.str[15] == '1';
    }

    public boolean zero() {
        boolean isZero = true;
        for (char ch : this.str) {
            isZero = isZero && ch == '0';
        }
        return isZero;
    }
}

