/*
 * Decompiled with CFR 0.152.
 */
package hardware;

import bits.BitString;
import hardware.DataMemory;
import java.util.Scanner;

public class RAM
implements DataMemory {
    public static final int DEFAULT_RAM_SIZE = 32768;
    private int size;
    BitString[] backingStore;

    public RAM(int size) {
        this.size = size;
        this.backingStore = new BitString[size];
    }

    public RAM() {
        this(32768);
    }

    private int validateAddress(BitString address, int max, String functionName) {
        int nAddress = address.toInt();
        if (nAddress >= max) {
            throw new IndexOutOfBoundsException(String.format("%s Bounds Exceeded in %s with %s [%d/%d]", "RAM", functionName, address, nAddress, max));
        }
        return nAddress;
    }

    private int validateAddress(BitString address, String functionName) {
        return this.validateAddress(address, this.size, functionName);
    }

    @Override
    public BitString get(BitString address) {
        return this.backingStore[this.validateAddress(address, "get")];
    }

    @Override
    public void set(BitString address, BitString value) {
        this.backingStore[this.validateAddress((BitString)address, (String)"set")] = value;
    }

    @Override
    public short fillFromScanner(Scanner fin, BitString startAddress) {
        int addr = startAddress.toInt();
        short wordsRead = 0;
        while (fin.hasNextLine()) {
            String word = fin.nextLine();
            this.backingStore[addr++] = new BitString(word);
            wordsRead = (short)(wordsRead + 1);
        }
        return wordsRead;
    }

    @Override
    public short[] rangeToShort(BitString first, BitString last) {
        int nStart = this.validateAddress(first, "rangeToShort");
        int nLast = this.validateAddress(last, "rangeToShort");
        int nSize = nLast - nStart + 1;
        short[] retval = new short[nSize];
        for (int i = 0; i < nSize; ++i) {
            retval[i] = this.backingStore[nStart].toShort();
            ++nStart;
        }
        return retval;
    }

    @Override
    public BitString[] rangeToBitString(BitString first, BitString last) {
        int nStart = this.validateAddress(first, "rangeToBitString");
        int nLast = this.validateAddress(last, "rangeToBitString");
        int nSize = nLast - nStart + 1;
        BitString[] retval = new BitString[nSize];
        for (int i = 0; i < nSize; ++i) {
            retval[i] = this.backingStore[nStart];
            ++nStart;
        }
        return retval;
    }
}

