/*
 * Decompiled with CFR 0.152.
 */
package hardware;

import bits.BitString;
import hardware.Memory;

public class Screen
implements Memory {
    public static final short SCREEN_WIDTH = 80;
    public static final short SCREEN_HEIGHT = 25;
    public static final short SCREEN_SIZE = 2000;
    BitString[] backingStore = new BitString[2000];

    private short validateAddress(BitString address, short max, String functionName) {
        short nAddress = address.toShort();
        if (nAddress >= max) {
            throw new IndexOutOfBoundsException(String.format("%s Bounds Exceeded in %s with %s [%d/%d]", "Screen", functionName, address, nAddress, max));
        }
        return nAddress;
    }

    private short validateAddress(BitString address, String functionName) {
        return this.validateAddress(address, (short)2000, functionName);
    }

    @Override
    public BitString get(BitString address) {
        short nAddress = this.validateAddress(address, "get");
        return this.backingStore[nAddress];
    }

    @Override
    public void set(BitString address, BitString value) {
        short nAddress = this.validateAddress(address, "set");
        this.backingStore[nAddress] = value;
    }

    public short[] rangeToShort(BitString first, BitString last) {
        short nStart = this.validateAddress(first, "rangeToShort");
        short nLast = this.validateAddress(last, "rangeToShort");
        short nSize = (short)(nLast - nStart + 1);
        short[] retval = new short[nSize];
        for (short i = 0; i < nSize; i = (short)(i + 1)) {
            retval[i] = this.backingStore[nStart].toShort();
            nStart = (short)(nStart + 1);
        }
        return retval;
    }

    public BitString[] rangeToBitString(BitString first, BitString last) {
        short nStart = this.validateAddress(first, "rangeToBitString");
        short nLast = this.validateAddress(last, "rangeToBitString");
        short nSize = (short)(nLast - nStart + 1);
        BitString[] retval = new BitString[nSize];
        for (short i = 0; i < nSize; i = (short)(i + 1)) {
            retval[i] = this.backingStore[nStart];
            nStart = (short)(nStart + 1);
        }
        return retval;
    }
}

