/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import messages.BoxedMessage;
import messages.Message;
import messages.TextMessage;
import messages.VerticalMessage;

public class DecorateMessages {
    private List<String> arguments;
    private List<Message> messages;

    public DecorateMessages(String[] args) {
        this.arguments = new ArrayList<String>(Arrays.asList(args));
        this.messages = new ArrayList<Message>();
    }

    private void run() {
        for (String arg : this.arguments) {
            this.processArgument(arg);
        }
        for (Message m : this.messages) {
            System.out.println(m);
        }
    }

    private void processArgument(String fname) {
        TextMessage x = new TextMessage(fname);
        this.messages.add(x);
        BoxedMessage bx = new BoxedMessage(x);
        this.messages.add(bx);
        bx = new BoxedMessage(x, "012345678");
        BoxedMessage bbx = new BoxedMessage(bx);
        this.messages.add(bbx);
        bx = new BoxedMessage(x, "**********");
        this.messages.add(new BoxedMessage(new VerticalMessage(x, bx)));
        bx = new BoxedMessage(x, "**********");
        bbx = new BoxedMessage(new VerticalMessage(x, bx));
        this.messages.add(bbx);
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("usage: Decorate Messages [<data file name>]+");
            System.err.println();
            System.err.println("       where");
            System.err.println("         <data file name> - names a file containing text description of Messages");
            System.exit(1);
        }
        DecorateMessages dm = new DecorateMessages(args);
        dm.run();
    }
}

