/*
 * Decompiled with CFR 0.152.
 */
package messages;

import messages.Message;

public class VerticalMessage
extends Message {
    private final Message top;
    private final Message bottom;

    public VerticalMessage(Message top, Message bottom) {
        super(Math.max(top.width(), bottom.width()), top.height() + bottom.height());
        this.top = top;
        top.width(this.minimum_width);
        this.bottom = bottom;
        bottom.width(this.minimum_width);
    }

    @Override
    public String line(int i) {
        this.validateLineIndex(i);
        Object theLine = "                                                                                                    ".substring(0, this.width());
        if (0 <= i && i < this.top.height()) {
            theLine = this.top.line(i) + (String)theLine;
        } else if (i - this.top.height() < this.bottom.height()) {
            theLine = this.bottom.line(i - this.top.height()) + (String)theLine;
        }
        return ((String)theLine).substring(0, this.width());
    }
}

