/*
 * Decompiled with CFR 0.152.
 */
package frozen;

import frozen.FrozenTreat;
import frozen.IceCream;
import frozen.Sundae;
import frozen.Yoghurt;
import java.util.Scanner;

public class Receipt {
    Node head = null;

    public FrozenTreat nextFrozenTreat(Scanner frozenTreatDescriptions) {
        String line = frozenTreatDescriptions.nextLine();
        Scanner lineScanner = new Scanner(line = line.trim());
        String treatType = lineScanner.next();
        if (treatType.equals("IceCream")) {
            String flavor = lineScanner.next();
            return new IceCream(flavor);
        }
        if (treatType.equals("Yoghurt")) {
            String flavor = lineScanner.next();
            return new Yoghurt(flavor);
        }
        if (treatType.equals("Sundae")) {
            String topping = lineScanner.next();
            FrozenTreat base = this.nextFrozenTreat(frozenTreatDescriptions);
            return new Sundae(topping, base);
        }
        return null;
    }

    public Receipt(Scanner fin) {
        while (fin.hasNextLine()) {
            FrozenTreat treat = this.nextFrozenTreat(fin);
            this.head = this.add(this.head, treat);
        }
    }

    private Node add(Node curr, FrozenTreat treat) {
        if (curr == null) {
            return new Node(treat);
        }
        curr.next = this.add(curr.next, treat);
        return curr;
    }

    public double total() {
        double t = 0.0;
        Node curr = this.head;
        while (curr != null) {
            t += curr.treat.price();
            curr = curr.next;
        }
        return t;
    }

    public String toString() {
        Object receiptString = "";
        String separator = "";
        Node curr = this.head;
        while (curr != null) {
            receiptString = (String)receiptString + separator + curr.treat;
            separator = "\n";
            curr = curr.next;
        }
        return receiptString;
    }

    class Node {
        FrozenTreat treat;
        Node next;

        public Node(FrozenTreat treat, Node next) {
            this.treat = treat;
            this.next = next;
        }

        public Node(FrozenTreat treat) {
            this(treat, null);
        }
    }
}

