/*
 * Decompiled with CFR 0.152.
 */
package animals;

import animals.Animal;

public class Dictionary {
    Node root = null;

    public boolean contains(String maybe) {
        return this.contains(this.root, maybe);
    }

    private boolean contains(Node curr, String maybe) {
        boolean found = false;
        if (curr != null) {
            int match = curr.data.compareTo(maybe);
            found = match < 0 ? this.contains(curr.right, maybe) : (match == 0 ? true : this.contains(curr.left, maybe));
        }
        return found;
    }

    public boolean delete(String victim) {
        if (this.contains(victim)) {
            this.root = this.delete(this.root, victim);
            return true;
        }
        return false;
    }

    private Node smallest(Node curr) {
        while (curr.left != null) {
            curr = curr.left;
        }
        return curr;
    }

    private Node delete(Node curr, String victim) {
        Node retval = curr;
        if (curr != null) {
            int match = curr.data.compareTo(victim);
            if (match < 0) {
                curr.left = this.delete(curr.left, victim);
            } else if (match > 0) {
                curr.right = this.delete(curr.right, victim);
            } else if (curr.left == null) {
                retval = curr.right;
            } else if (curr.right == null) {
                retval = curr.left;
            } else {
                Node successor = this.smallest(curr.right);
                curr.data = successor.data;
                curr.right = this.delete(curr.right, successor.data.getName());
            }
        }
        return retval;
    }

    public void add(Animal newbie) {
        if (this.root == null) {
            this.root = new Node(newbie);
        } else {
            this.add(this.root, newbie);
        }
    }

    private void add(Node curr, Animal newbie) {
        if (curr.data.compareTo(newbie) < 0) {
            if (curr.right == null) {
                curr.right = new Node(newbie);
            } else {
                this.add(curr.right, newbie);
            }
        } else if (curr.left == null) {
            curr.left = new Node(newbie);
        } else {
            this.add(curr.left, newbie);
        }
    }

    private String indentedRepresentation(Node curr, String prefix) {
        Object rep = "";
        if (curr != null) {
            rep = (String)rep + this.indentedRepresentation(curr.left, prefix + "  ");
            rep = (String)rep + prefix + curr.data + "\n";
            rep = (String)rep + this.indentedRepresentation(curr.right, prefix + "  ");
        }
        return rep;
    }

    private String indentedRepresentation(Node curr) {
        return this.indentedRepresentation(curr, "");
    }

    private String flushRepresentation(Node curr) {
        Object rep = "";
        if (curr != null) {
            rep = (String)rep + this.flushRepresentation(curr.left);
            rep = (String)rep + curr.data + "\n";
            rep = (String)rep + this.flushRepresentation(curr.right);
        }
        return rep;
    }

    public String toString() {
        return this.flushRepresentation(this.root);
    }

    public int size() {
        return this.size(this.root);
    }

    private int size(Node curr) {
        int mySize = 0;
        if (curr != null) {
            mySize = this.size(curr.left) + 1 + this.size(curr.right);
        }
        return mySize;
    }

    class Node {
        Animal data;
        Node left;
        Node right;

        Node(Animal data) {
            this.data = data;
            this.left = null;
            this.right = null;
        }
    }
}

