/*
 * Decompiled with CFR 0.152.
 */
package rlinked;

import fruit.Fruit;

public class ListOfFruit {
    private ListOfFruitNode head = null;

    public void add(Fruit newFruit) {
        ListOfFruitNode newbie = new ListOfFruitNode(newFruit);
        if (this.head == null) {
            this.head = newbie;
        } else {
            ListOfFruitNode curr = this.head;
            while (curr.next != null) {
                curr = curr.next;
            }
            curr.next = newbie;
        }
    }

    public boolean contains(String fruitName, String varietyName) {
        return this.contains(this.head, fruitName, varietyName);
    }

    private boolean contains(ListOfFruitNode curr, String fruitName, String varietyName) {
        return curr != null && (curr.fruit.match(fruitName, varietyName) || this.contains(curr.next, fruitName, varietyName));
    }

    public boolean delete(String fruitName, String varietyName) {
        boolean actuallyDeleted = false;
        if (this.contains(fruitName, varietyName)) {
            this.head = this.delete(this.head, fruitName, varietyName);
            actuallyDeleted = true;
        }
        return actuallyDeleted;
    }

    private ListOfFruitNode delete(ListOfFruitNode curr, String fruitName, String varietyName) {
        ListOfFruitNode rest = curr;
        if (curr == null) {
            rest = null;
        } else if (curr.fruit.match(fruitName, varietyName)) {
            rest = curr.next;
        } else {
            curr.next = this.delete(curr.next, fruitName, varietyName);
        }
        return rest;
    }

    public String toString() {
        String strRepresentation = "";
        String separator = "";
        ListOfFruitNode curr = this.head;
        while (curr != null) {
            strRepresentation = String.format("%s%s%s", strRepresentation, separator, curr.fruit);
            separator = "\n";
            curr = curr.next;
        }
        return strRepresentation;
    }

    private class ListOfFruitNode {
        final Fruit fruit;
        ListOfFruitNode next;

        public ListOfFruitNode(Fruit myFruit, ListOfFruitNode next) {
            this.fruit = myFruit;
            this.next = next;
        }

        public ListOfFruitNode(Fruit myFruit) {
            this(myFruit, null);
        }
    }
}

