/*
 * Decompiled with CFR 0.152.
 */
package critters;

import critters.Attribute;
import java.util.Random;

public class Critter {
    protected Attribute strength;
    protected Attribute dexterity;
    protected Attribute intelligence;
    protected Attribute hitPoints;
    private String name;

    public Critter(String name, int STR, int DEX, int INT, int HP) {
        this.name = name;
        this.strength = new Attribute(Attribute.Type.STR, STR);
        this.dexterity = new Attribute(Attribute.Type.DEX, DEX);
        this.intelligence = new Attribute(Attribute.Type.INT, INT);
        this.hitPoints = new Attribute(Attribute.Type.HP, HP);
    }

    public boolean attack(Critter opponent, Random random) {
        return this.strength.challenge(opponent.strength, random);
    }

    public int calculateDamage(Random random) {
        return random.nextInt(1, 7);
    }

    public int doDamage(Critter opponent, Random random) {
        int damage = this.calculateDamage(random);
        opponent.hitPoints.nerf(damage);
        return damage;
    }

    public boolean isAlive() {
        return this.hitPoints.current() > 0;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        String template = "%s: %s\nAttributes--\n%s\n%s\n%s\n%s\n";
        return String.format(template, this.getClass().getSimpleName(), this.name, this.strength, this.dexterity, this.intelligence, this.hitPoints);
    }
}

