/*
 * Decompiled with CFR 0.152.
 */
package binfile;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;

public class RB {
    private String fileName;

    public RB(String fileName) {
        this.fileName = fileName;
    }

    public void run() {
        Path path = Paths.get(this.fileName, new String[0]);
        try (SeekableByteChannel channel = Files.newByteChannel(path, StandardOpenOption.WRITE, StandardOpenOption.READ);){
            boolean BUFFER_SIZE = true;
            ByteBuffer buffer = ByteBuffer.allocate(1);
            int uc = 0;
            while (channel.read(buffer) > 0) {
                char ch = (char)buffer.get(0);
                if ('A' <= ch && ch <= 'Z') {
                    ++uc;
                }
                System.out.print(ch);
                buffer.clear();
            }
            System.out.printf("\nUpper-Case Count = %d\n", uc);
        }
        catch (IOException e) {
            System.err.printf("Unable to read input file %s.\n", this.fileName);
            e.printStackTrace(System.err);
            System.exit(2);
        }
    }

    public static void main(String[] args) {
        if (args.length == 1) {
            RB readBytes = new RB(args[0]);
            readBytes.run();
        } else {
            System.err.println("Usage: java RB <inputFileName>");
            System.err.println("       <inputFileName> - path to input file");
            System.err.println();
            System.err.println("Program opens file in binary mode and prints each");
            System.err.println("byte to the screen.");
            System.exit(1);
        }
    }
}

