/*
 * Decompiled with CFR 0.152.
 */
package binfile;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;

public class XB {
    private String fileName;
    private char key;

    public XB(String fileName, char key) {
        this.fileName = fileName;
        this.key = key;
    }

    public void run() {
        Path path = Paths.get(this.fileName, new String[0]);
        try (SeekableByteChannel channel = Files.newByteChannel(path, StandardOpenOption.WRITE, StandardOpenOption.READ);){
            boolean BUFFER_SIZE = true;
            ByteBuffer buffer = ByteBuffer.allocate(1);
            while (channel.read(buffer) > 0) {
                buffer.flip();
                byte b = buffer.get();
                b = (byte)(b ^ this.key);
                buffer.clear();
                buffer.put(b);
                buffer.flip();
                channel.position(channel.position() - 1L);
                channel.write(buffer);
                buffer.clear();
            }
        }
        catch (IOException e) {
            System.err.printf("Unable to read input file %s.\n", this.fileName);
            e.printStackTrace(System.err);
            System.exit(2);
        }
    }

    public static void main(String[] args) {
        if (args.length == 2) {
            String fileName = args[0];
            String keyString = args[1];
            if (keyString.length() != 1) {
                System.err.printf("Key character must be one character long: %s unusable.\n", keyString);
                System.exit(3);
            }
            char key = keyString.charAt(0);
            XB readBytes = new XB(fileName, key);
            readBytes.run();
        } else {
            System.err.println("Usage: java XB <fileName> <keyChar>");
            System.err.println("       <inputFileName> - path to input file");
            System.err.println();
            System.err.println("Program opens file in binary mode and prints each");
            System.err.println("byte to the screen.");
            System.exit(1);
        }
    }
}

