package bits;

public class BitString {
  private static final int WIDTH = 16;
  private static final BitString one = new BitString((short) 1);
  private static final BitString negativeOne = new BitString((short) -1);
  protected char[] str;

	public BitString(String s) {
    str = new char[WIDTH];
    for (int i = 16; i > 0; i--) {
      int j = i - 1;
      int k = 16 - i;
      str[j] = s.charAt(k);
    }
  }

  public BitString(short v) {
    str = new char[WIDTH];
    for (int i = 0; i < WIDTH; i++) {
      str[i] = (char)('0' + (v & 1));
      v >>= 1;
    }
  }

  public BitString() {
    this((short)0);
  }

  public BitString(BitString other) {
    str = new char[WIDTH];
    for (int i = 0; i < WIDTH; i++)
      str[i] = other.str[i];
  }

  public int toInt() {
    int value = 0;
    for (int i = 16; i > 0; i--) {
      int j = i - 1;
      value = value * 2 + (str[j] - '0');
    }
    return value;
  }

  public short toShort() {
    return (short) toInt();
  }
  public String toString() {
    String retval = "";
    String separator = "";
    for (int i = WIDTH; i > 0; i--) {
      int j = i - 1;
      if (i % 4 == 0) {
        retval += separator;
        separator = " ";
      }
      retval += str[j];
    }
    return retval;
  }

  public void andInPlace(BitString rhs) {
    for (int i = 0; i < WIDTH; i++)
      str[i] = (str[i] == '1' && rhs.str[i] == '1')?'1':'0';
  }

  public void decrementInPlace() {
    plusInPlace(negativeOne);
  }

  public void incrementInPlace() {
    plusInPlace(one);
  }

  public void invertInPlace() {
    for (int i = 0; i < WIDTH; i++)
      str[i] = (char) ((1 - (str[i] - '0')) + '0');
  }

  public void orInPlace(BitString rhs) {
    for (int i = 0; i < WIDTH; i++)
      str[i] = (str[i] == '0' && rhs.str[i] == '0') ? '0' : '1';
  }

  public void plusInPlace(BitString rhs) {
    int carry = 0;
    for (int i = 0; i < WIDTH; i++) {
      int count = (str[i] - '0') + (rhs.str[i] - '0') + carry;
      str[i] = ((count & 1) == 1)?'1':'0';
      carry = count >> 1;
    }
  }

  public void xorInPlace(BitString rhs) {
    for (int i = 0; i < WIDTH; i++)
      str[i] = (str[i] != rhs.str[i]) ? '1' : '0';
  }

  public BitString and(BitString rhs) {
    BitString result = new BitString(rhs);
    result.andInPlace(this);
    return result;
  }

  public BitString decrement() {
    BitString result = new BitString(this);
    result.decrementInPlace();
    return result;
  }

  public BitString increment() {
    BitString result = new BitString(this);
    result.incrementInPlace();
    return result;
  }

  public BitString invert() {
    BitString result = new BitString(this);
    result.invertInPlace();
    return result;
  }

  public BitString or(BitString rhs) {
    BitString result = new BitString(rhs);
    result.orInPlace(this);
    return result;
  }

  public BitString plus(BitString rhs) {
    BitString result = new BitString(rhs);
    result.plusInPlace(this);
    return result;
  }

  public BitString xor(BitString rhs) {
    BitString result = new BitString(rhs);
    result.xorInPlace(this);
    return result;
  }

  public boolean negative() {
    return str[15] == '1';
  }

  public boolean zero() {
    boolean isZero = true;
    for (char ch : str)
      isZero = isZero && (ch == '0');
    return isZero;
  }
}
