package hardware;

import java.util.Scanner;

import bits.BitString;

public class RAM
  implements DataMemory {
  public static final int DEFAULT_RAM_SIZE = 32768;
  private int size;
  BitString [] backingStore;

  public RAM(int size) {
    this.size = size;
    backingStore = new BitString[size];
  }

  public RAM() {
    this(DEFAULT_RAM_SIZE);
  }

  private int validateAddress(BitString address, int max, String functionName) {
    int nAddress = address.toInt();
    if (nAddress >= max)
      throw new IndexOutOfBoundsException(String.format("%s Bounds Exceeded in %s with %s [%d/%d]",
          "RAM", functionName, address, nAddress, max));
    return nAddress;
  }

  private int  validateAddress(BitString address, String functionName) {
    return validateAddress(address, size, functionName);
  }

  public BitString get(BitString address) {
    return backingStore[validateAddress(address, "get")];
  }

  public void set(BitString address, BitString value) {
   backingStore[validateAddress(address, "set")] = value;
  }

  public short fillFromScanner(Scanner fin, BitString startAddress) {
    int addr = startAddress.toInt();
    short wordsRead = 0;
    while (fin.hasNextLine()) {
      String word = fin.nextLine();
      backingStore[addr++] = new BitString(word);
      wordsRead++;
    }
    return wordsRead;
  }

  public short[] rangeToShort(BitString first, BitString last) {
    int nStart = validateAddress(first, "rangeToShort");
    int nLast = validateAddress(last, "rangeToShort");
    int nSize = (short) (nLast - nStart + 1);

    short[] retval = new short[nSize];
    for (int i = 0; i < nSize; i++) {
      retval[i] = backingStore[nStart].toShort();
      nStart++;
    }
    return retval;
  }

  public BitString[] rangeToBitString(BitString first, BitString last) {
    int nStart = validateAddress(first, "rangeToBitString");
    int nLast = validateAddress(last, "rangeToBitString");
    int nSize = nLast - nStart + 1;

    BitString[] retval = new BitString[nSize];
    for (int i = 0; i < nSize; i++) {
      retval[i] = backingStore[nStart];
      nStart++;
    }
    return retval;
  }
}
