package hardware;

import bits.BitString;
/**
 * Screen
 */
public class Screen
  implements Memory {
  public static final short SCREEN_WIDTH = 80;
  public static final short SCREEN_HEIGHT = 25;
  public static final short SCREEN_SIZE = SCREEN_WIDTH * SCREEN_HEIGHT;

  BitString [] backingStore;

  public Screen() {
    backingStore = new BitString[SCREEN_SIZE];
  }

  private short validateAddress(BitString address, short max, String functionName) {
    short nAddress = address.toShort();
    if (nAddress >= max)
      throw new IndexOutOfBoundsException(String.format("%s Bounds Exceeded in %s with %s [%d/%d]",
                                                        "Screen", functionName, address, nAddress, max));
    return nAddress;
  }
  private short validateAddress(BitString address, String functionName) {
    return validateAddress(address, SCREEN_SIZE, functionName);
  }

  public BitString get(BitString address) {
    short nAddress = validateAddress(address, "get");
    return backingStore[nAddress];
  }

  public void set(BitString address, BitString value) {
    short nAddress = validateAddress(address, "set");
    backingStore[nAddress] = value;
  }

  public short[] rangeToShort(BitString first, BitString last) {
    short nStart = validateAddress(first, "rangeToShort");
    short nLast = validateAddress(last, "rangeToShort");
    short nSize = (short) (nLast - nStart + 1);

    short[] retval = new short[nSize];
    for (short i = 0; i < nSize; i++) {
      retval[i] = backingStore[nStart].toShort();
      nStart++;
    }
    return retval;
  }

  public BitString[] rangeToBitString(BitString first, BitString last) {
    short nStart = validateAddress(first, "rangeToBitString");
    short nLast = validateAddress(last, "rangeToBitString");
    short nSize = (short)(nLast-nStart+1);

    BitString[] retval = new BitString[nSize];
    for (short i = 0; i < nSize; i++) {
      retval[i] = backingStore[nStart];
      nStart++;
    }
    return retval;

  }
}
