package simulation;

import bits.BitString;
import hardware.RAM;
/**
 * CPUClient
 */
public class CPUClient {

	public CPUClient() {
  }

  public void run() {
    testOutBitString();
    testOutRAM();
  }

  public void testOutBitString() {
    BitString q = new BitString("1000000000000000");
    BitString r = new BitString((short) 32767);
    BitString s = new BitString((short) 128);
    System.out.println(String.format("q = %s (%d)", q, q.toShort()));
    System.out.println(String.format("r = %s (%d)", r, r.toShort()));
    System.out.println(String.format("s = %s (%d)", s, s.toShort()));

    BitString a = q.or(r);
    System.out.println(String.format("q | r = %s (%d)", a, a.toShort()));
    a = q.or(s);
    System.out.println(String.format("q | s = %s (%d)", a, a.toShort()));
    a = q.and(s);
    System.out.println(String.format("q & s = %s (%d)", a, a.toShort()));
    a = q.plus(r);
    System.out.println(String.format("q + r = %s (%d)", a, a.toShort()));
    a = q.invert();
    System.out.println(String.format("~q = %s (%d)", a, a.toShort()));
    a = r.invert();
    System.out.println(String.format("~r = %s (%d)", a, a.toShort()));
    a = s.invert();
    System.out.println(String.format("~s = %s (%d)", a, a.toShort()));
  }

  public void testOutRAM() {
    RAM ram = new RAM();
    for (int i = 0; i < RAM.DEFAULT_RAM_SIZE; i++) {
      short j = (short) i;
      ram.set(new BitString(j), new BitString(j));
    }

    BitString [] q = ram.rangeToBitString(new BitString((short)1000), new BitString((short)1100));

  for (int i = 0; i < q.length; ++i) {
    System.out.println(String.format("[%d] = %s (%d)", i+1000, q[i], q[i].toShort()));

  }


  }

  public static void main(String[] args) {
    CPUClient cpu = new CPUClient();
    cpu.run();
  }
}
