package bits;

public class Instruction
  extends BitString {

  public Instruction(short v) {
    super(v);
  }

  public Instruction() {
    super();
  }

  public Instruction(Instruction instruction) {
    super(instruction);
  }

  public Instruction(BitString bitstring) {
    super(bitstring);
  }

  public Instruction(String str) {
    super(str);
  }

  public boolean CInstruction() {
    return str[15] == '1';
  }

  public boolean AInstruction() {
    return str[15] == '0';
  }

  public boolean a() {
    return str[12] == '1';
  }

  public boolean zx() {
    return str[11] == '1';
  }

  public boolean nx() {
    return str[10] == '1';
  }

  public boolean zy() {
    return str[9] == '1';
  }

  public boolean ny() {
    return str[8] == '1';
  }

  public boolean f() {
    return str[7] == '1';
  }

  public boolean no() {
    return str[6] == '1';
  }

  public boolean A() {
    return str[5] == '1';
  }

  public boolean D() {
    return str[4] == '1';
  }

  public boolean M() {
    return str[3] == '1';
  }

  public boolean JLesser() {
    return str[2] == '1';
  }

  public boolean JEqual() {
    return str[1] == '1';
  }

  public boolean JGreater() {
    return str[0] == '1';
  }

  public boolean jump(boolean n, boolean z) {
    boolean jLess = str[2] == '1';
    boolean jEquals = str[1] == '1';
    boolean jGreater = str[0] == '1';

    return (jLess && n) || (jGreater && !n && !z) || (jEquals && z);
  }
}
