package hardware;

import bits.BitString;
import bits.Instruction;
import bits.InstructionToASM;
import hardware_interface.InstructionMemory;
import hardware_interface.Memory;
import hardware_interface.N2TCPU;
import util.CSIIILogger;

/**
 * N2TCPU
 */
public class CPU
 implements N2TCPU{
  private Memory data;
  private InstructionMemory instructions;

  private CSIIILogger logger;
  private boolean noMoreProgram;
  private BitString D;
  private BitString A;
  private Instruction IDR;
  private BitString PC;

	public CPU(Memory data, InstructionMemory instructions) {
    this.data = data;
    this.instructions = instructions;
    noMoreProgram = false;
    D = new BitString();
    A = new BitString();
    PC = new BitString();
    IDR = new Instruction();
    logger = new CSIIILogger();
  }

  public void setLogger(CSIIILogger logger) {
    this.logger = logger;
  }

  public String state() {
    String M_A = "";
    if (A.toInt() < data.capacity())
      M_A = String.format("  M[A] = %s (%d)\n", data.get(A),data.get(A).toShort());

    return "CPU State:\n" +
        String.format("  A    = %s (%d)\n", A, A.toShort()) +
        M_A +
        String.format("  D    = %s (%d)\n", D, D.toShort()) +
        String.format("  PC   = %s (%d)\n", PC, PC.toShort()) +
        String.format("  IDR  = %s [%s]\n", IDR, InstructionToASM.toASM(IDR));
  }

  public boolean halt() {
    return noMoreProgram;
  }

  public void fetch() {
    noMoreProgram = PC.toInt() >= instructions.size();

    if (!noMoreProgram) {
      IDR = instructions.get(PC);
      logger.println(getClass().getName(), "fetch",
                     String.format("[%s] %s (%s)", PC, IDR, InstructionToASM.toASM(IDR)));
      PC.incrementInPlace();
    }
  }

  public void decode() {

  }

  public void execute() {
    if (IDR.CInstruction()) {
      BitString x = D;
      BitString y = !IDR.a() ? A : data.get(A);

      if ((x == null) || (y == null))
        System.err.println(String.format("Panic: x = %s, y = %s", x, y));

      if (IDR.zx())
        x = new BitString();
      if (IDR.nx())
        x = x.invert();

      if (IDR.zy())
        y = new BitString();
      if (IDR.ny())
        y = y.invert();

      BitString out;
      if (IDR.f())
        out = x.add(y);
      else
        out = x.and(y);

      if (IDR.no())
        out = out.invert();

      logger.println(getClass().getName(), "execute", String.format("out = %s", out));

      if (IDR.M())
        data.set(A, out);
      if (IDR.A())
        A = out;
      if (IDR.D())
        D = out;

      if (IDR.jump(out.negative(), out.zero()))
        PC = A;
    } else if (IDR.AInstruction()) {
      A = IDR;
    }
  }

}
