package hardware;

import java.util.Scanner;

import bits.BitString;
import bits.Instruction;
import bits.InstructionToASM;
import hardware_interface.InstructionMemory;

public class ROM
implements InstructionMemory {
  public static final int DEFAULT_ROM_SIZE = 16384;
  private RAM backingStore;

  public ROM(int size) {
    backingStore = new RAM(size);
  }

  public ROM() {
    this(DEFAULT_ROM_SIZE);
  }

  public int capacity() {
    return backingStore.capacity();
  }

  public int size() {
    return backingStore.size();
  }

  public Instruction get(BitString address) {
    BitString word = backingStore.get(address);
    return new Instruction(word);
  }

  public void set(BitString address, Instruction vaule) {
    // do nothing --- could reasonably throw
  }

  public short fillFromScanner(Scanner fin, BitString startAddress) {
    return backingStore.fillFromScanner(fin, startAddress);
  }

  public short fillFromASMScanner(Scanner asmFin, BitString startAddress) {
    short wordsRead = 0;
    while (asmFin.hasNextLine()) {
      String word = asmFin.nextLine();
      if (word.isBlank())
        continue;
      backingStore.set(startAddress, InstructionToASM.fromASM(word));
      startAddress.incrementInPlace();
      wordsRead++;
    }
    return wordsRead;
  }

  public short[] rangeToShort(BitString first, BitString last) {
    return backingStore.rangeToShort(first, last);
  }

  public BitString[] rangeToBitString(BitString first, BitString last) {
    return backingStore.rangeToBitString(first, last);
  }

  public Instruction[] rangeToInstruction(BitString first, BitString last) {
    BitString[] words = backingStore.rangeToBitString(first, last);
    Instruction[] instructions = new Instruction[words.length];
    int i = 0;
    for (BitString word : words)
      instructions[i++] = new Instruction(word);

    return instructions;
  }

  public String[] rangeToASM(BitString first, BitString last) {
    Instruction[] instructions = rangeToInstruction(first, last);
    String [] asm = new String[instructions.length];
    int i = 0;
    for (Instruction instruction : instructions)
      asm[i++] = InstructionToASM.toASM(instruction);

    return asm;
  }

}
