package hardware_interface;

import bits.BitString;
import bits.Instruction;

/**
 * Nand2Tetris CPU interface - the MUST-HAVE routines
 *
 */
public interface N2TCPU {
  /**
   * Return the current state of the CPU: the A register, the D
   * register, the PC register, the IDR register. These can all be
   * reported as BitString (and, for A/D/PC, as short, too). The IDR
   * can be reported with assembly or bits.
   */
  public String state();

  /**
   * Is the CPU done? If so, halt.
   *
   * You know you are done when the PC > ROM.size() (you're reading
   * past the loaded program).
   */
  public boolean halt();

  /**
   * fetch the next instruction from ROM into the CPU's IDR.
   * Increment the PC by 1
   */
  public void fetch();

  /**
   * decode the IDR: do everything to prepare to execute the
   * instruction.
   */
  public void decode();

  /**
   * Execute the instruction in the IDR:
   * if IDR.isAInstruction
   *   A = IDR // load the address from IDR to A
   * else
   *   set BitString x to D
   *   set BitString y to either A or RAM[A]
   *   use the c-bits in IDR to combine x,y into out
   *     (this IS the ALU)
   *   use the dest bits to store results to MDA registers
   *   use the jmp bits (and z/n bits of out) to maybe set PC = A
   */
  public void execute();
}
