package hardware_interface;

import bits.BitString;

/**
 * PrintableMemory - Routines so the main program can examine portions
 * of the memory. Printable because the results can be used to print
 * memory contents.
 */
public interface PrintableHardware {
  /**
   * Get the contents of the memory as an array of BitString
   *
   * Note that the addresses are unsigned: use BitString.asInt to get the
   * index into the memory (and ignore the sign bit being set from bit
   * 15).
   *
   * @param first - location in the memory where the sub-array begins
   * @param last  - location in the memory where the sub-array ends
   * @note Both memory[first] and memory[last] are included in the
   *       returned value; the length of the returned array is therefore
   *       last-first+1.
   * @return a brand new array containing the memory contents of the
   *         memory as BitString
   * @throws IndexOutOfBoundsException if either address is beyond the
   *         bounds (capacity()) of the memory.
   */
  public BitString[] rangeToBitString(BitString first, BitString last);

  /**
   * Get the contents of the memory as an array of short
   *
   * Note that the addresses are unsigned: use BitString.asInt to get the
   * index into the memory (and ignore the sign bit being set from bit
   * 15).
   *
   * @param first - location in the memory where the sub-array begins
   * @param last  - location in the memory where the sub-array ends
   * @note Both memory[first] and memory[last] are included in the
   *       returned value; the length of the returned array is therefore
   *       last-first+1.
   * @return a brand new array containing the memory contents of the
   *         memory as BitString
   * @throws IndexOutOfBoundsException if either address is beyond the
   *         bounds (capacity()) of the memory.
   */
  public short[] rangeToShort(BitString first, BitString last);

}
