package util;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

public class CSIIILogger {
  private final static String DEFAULT_LOG_NAME="Log";
  private List<PrintStream> logs;
  private String name;
  private boolean logging;

  public CSIIILogger(String name) {
    this.name = name;
    logs = new ArrayList();
    logging = true;
  }

  public CSIIILogger() {
    this(DEFAULT_LOG_NAME);
    off();
  }


  public CSIIILogger(PrintStream log) {
    this();
    logs.add(log);
  }

  public CSIIILogger(String name, PrintStream log) {
    this(name);
    logs.add(log);
  }

  public void add(PrintStream logOut) {
    logs.add(logOut);
  }

  public void remove(PrintStream logOut) {
    logs.remove(logOut);
  }

  public void on() {
    logging = true;
  }

  public void off() {
    logging = false;
  }

  public boolean toggle() {
    return (logging = !logging);
  }

  private void _entering(String className, String methodName) {
    for (PrintStream log : logs) {
      log.printf("%s: entering %s.%s\n", name, className, methodName);
    }
  }

  public void entering(String className, String methodName) {
    if (logging)
      _entering(className, methodName);
  }

  private void _exiting(String className, String methodName) {
    for (PrintStream log : logs) {
      log.printf("%s: exiting %s.%s\n", name, className, methodName);
    }
  }

  public void exiting(String className, String methodName) {
    if (logging)
      _exiting(className, methodName);
  }

  private void _println(String className, String methodName, String message) {
    for (PrintStream log : logs) {
      log.printf("%s: %s.%s - %s\n", name, className, methodName, message);
    }
  }

  public void println(String className, String methodName, String message) {
    if (logging)
      _println(className, methodName, message);
  }
}
