package hardware_interface;

import bits.BitString;
import bits.Instruction;

/**
 * InstructionMemory - An "array" of *read-only* instructions.
 *
 * LoadableHardware permits the content to be set from a file.
 * PrintableHardware permits the main program to request sub-arrays of
 * the contents, expressed as strings or shorts.
 */
public interface InstructionMemory
    extends LoadableHardware, PrintableHardware {
  /**
   * Number of words in the memory; they have addresses [0..capacity()-1]
   */
  public int capacity();

  /**
   * Number of words in the memory that have been loaded or touched.
   *
   * @return the number of Instruction read when the memory was loaded.
   */
  public int size();

  /**
   * Get the contents of the memory from the given location.
   *
   * Note that the address is unsigned: use BitString.asInt to get the
   * index into the memory (and ignore the sign bit being set from bit
   * 15).
   *
   * @param address - location in the memory to return
   * @return the Instruction stored in the given location
   * @throws IndexOutOfBoundsException if address is beyond the bounds
   * (capacity()) of the memory.
   */
  public Instruction get(BitString address);

}
