import java.util.Objects;

/**
 * An alternate String class. You will use the public
 * methods (the interface) and need not worry about the
 * implementation.
 */
public class BCLStr
  implements Str {
  /**
   * Make a new, empty, Str.
   */
  public BCLStr() {
    _implementation = new StringBuffer();
  }

  /**
   * Make a new Str containing the given String
   * as its value.
   */
  public BCLStr(String value) {
    _implementation = new StringBuffer(value);
  }

  /**
   * Make a new, one character long, Str
   * with the given char as its value.
   */
  public BCLStr(char ch) {
    this();
    _implementation.append(ch);
  }

  /**
   * Make a copy of the original into a new
   * Str.
   */
  public BCLStr(Str original) {
    this();
    _implementation.append(original);
  }

  /**
   * @return a String copying the vaule of the Str
   */
  @Override
  public String toString() {
    return  _implementation.toString();
  }

  /**
   * @return true if o is an Str with the same vaule as this one;
   * false otherwise
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    BCLStr str = (BCLStr) o;
    return _implementation.equals(str._implementation);
  }

  /**
   * @return true if the value of this Str is just the given char;
   * false otherwise
   */
  public boolean equals(char ch) {
    if (isEmpty() || _implementation.length() > 1) return false;
    return _implementation.charAt(0) == ch;
    }

  /**
   * @return an appropriate hash code for use by a HashMap or HashSet
   * @note uses hashCode of _implementation
   */
  @Override
  public int hashCode() {
    return Objects.hash(_implementation);
  }

  /**
   * @return true if this Str is empty; false otherwise
   */
  public boolean isEmpty() {
    return _implementation.length() == 0;
  }

  /**
   * @returns first character in the Str
   * @note could also be last char if length is 1
   * @throws IndexOutOfBoundsException if the string is empty
   */
  public char first() {
    if (isEmpty()) throw new IndexOutOfBoundsException("No first character in an empty Str.");
    return  _implementation.charAt(0) ;
  }

  /**
   * @returns last character in the Str
   * @note could also be first char if length is 1
   * @throws IndexOutOfBoundsException if the string is empty
   */
  public char last() {
    if (isEmpty()) throw new IndexOutOfBoundsException("No last character in an empty Str.");
    return _implementation.charAt(_implementation.length()-1);
  }

  /**
   * @returns Str with all characters after first.
   * @note could be an empty Str if length is 1
   * @throws IndexOutOfBoundsException if the string is empty
   */
  public Str rest() {
    if (isEmpty()) throw new IndexOutOfBoundsException("No tail portion in an empty Str.");
    return new BCLStr(_implementation.substring(1));
  }

  /**
   * @returns Str with all characters between the first and last, exclusive
   * @note could be an empty Str if length is less than 3
   * @throws IndexOutOfBoundsException if the string is empty
   */
  public Str middle() {
    if (isEmpty()) throw new IndexOutOfBoundsException("No middle portion in an empty Str.");
    if (_implementation.length() < 3) return new BCLStr();
    return new BCLStr(_implementation.substring(1, _implementation.length()-1));
  }

  /**
   * @param newFirstCh first character in returned vaule
   * @return new Str with newFirstCh followed by this
   */
  public Str prepend(char newFirstCh) {
    BCLStr retval = new BCLStr(this);
    retval._implementation.insert(0, newFirstCh);
    return retval;
  }

  /**
   * @param newLastCh last character in returned vaule
   * @return new Str with this followed by newLastCh
   */
  public Str append(char newLastCh) {
    BCLStr retval = new BCLStr(this);
    retval._implementation.append(newLastCh);
    return retval;
  }

  //----------------------------------------------------------------------
  //              ALL IMPLEMENTATION DETAILS BELOW HERE
  //----------------------------------------------------------------------

  // The actual implementation of this foundations.Str.
  private StringBuffer _implementation;
}
