/**
 * An alternate String class. You will use the public
 * methods (the interface) and need not worry about the
 * implementation.
 */
public interface Str {
  /*
   * Make a new, empty, Str.
  public Str();

   * Make a new Str containing the given String
   * as its value.
  public Str(String value);

   * Make a new, one character long, Str
   * with the given char as its value.
  public Str(char ch);

   * Make a copy of the original into a new
   * Str.
  public Str(Str original);
  */

  /**
   * @return a String copying the vaule of the Str
   */
  public String toString();

  /**
   * @return true if o is an Str with the same vaule as this one;
   * false otherwise
   */
  public boolean equals(Object o);

  /**
   * @return true if the value of this Str is just the given char;
   * false otherwise
   */
  public boolean equals(char ch);

  /**
   * @return an appropriate hash code for use by a HashMap or HashSet
   * @note uses hashCode of _implementation
   */
  public int hashCode();

  /**
   * @return true if this Str is empty; false otherwise
   */
  public boolean isEmpty();

  /**
   * @returns first character in the Str
   * @note could also be last char if length is 1
   * @throws IndexOutOfBoundsException if the string is empty
   */
  public char first();

  /**
   * @returns last character in the Str
   * @note could also be first char if length is 1
   * @throws IndexOutOfBoundsException if the string is empty
   */
  public char last();

  /**
   * @returns Str with all characters after first.
   * @note could be an empty Str if length is 1
   * @throws IndexOutOfBoundsException if the string is empty
   */
  public Str rest();

  /**
   * @returns Str with all characters between the first and last, exclusive
   * @note could be an empty Str if length is less than 3
   * @throws IndexOutOfBoundsException if the string is empty
   */
  public Str middle();

  /**
   * @param newFirstCh first character in returned vaule
   * @return new Str with newFirstCh followed by this
   */
  public Str prepend(char newFirstCh);

  /**
   * @param newLastCh last character in returned vaule
   * @return new Str with this followed by newLastCh
   */
  public Str append(char newLastCh);
}
