public class Shape {
  protected String name;

  public Shape(String name) {
    this.name = name;
  }

  public double area() {
    return 0.0;
  }

  public static void main(String[] args) {
    String rainbow[] = { "red", "orange", "yellow", "green", "blue", "indigo", "violet" };
    Shape theShapes[] = new Shape[7];
    double width = 1.0;
    double height = 3.0;


    for (int i = 0; i < 7; i++) {
      if (i % 3 == 0) {
        theShapes[i] = new Rectangle(rainbow[i], width, height);
      } else if (i % 3 == 1) {
        theShapes[i] = new Triangle(rainbow[i], width, height);
      } else {
        theShapes[i] = new Circle(rainbow[i], height);
      }

      width *= 2.0;
      height *= 1.5;
    }

    for (int i = 0; i < 7; i++) {
      System.out.println(theShapes[i]);
    }
  }
}

class Rectangle
  extends Shape {
  private double width;
  private double height;

  public Rectangle(String name, double width, double height) {
    super(name);
    this.width = width;
    this.height = height;
  }

  @Override
  public double area() {
    return width * height;
  }
}

class Triangle
  extends Shape {
  private double base;
  private double height;

  // Constructor to initialize the size of a triangle
  Triangle(String name, double base, double height) {
    super(name);
    this.base = base;
    this.height = height;
  }

  @Override
  public double area() {
    return (base * height) / 2;
  }
}

class Circle
  extends Shape {
  private double radius;

  // Constructor to initialize the radius of a circle
  Circle(String name, double radius) {
    super(name);
    this.radius = radius;
  }

  @Override
  public double area() {
    return Math.PI * this.radius * this.radius;
  }
}
