(TeX-add-style-hook
 "hMathPractice"
 (lambda ()
   (setq TeX-command-extra-options
         "-shell-escape")
   (TeX-add-to-alist 'LaTeX-provided-class-options
                     '(("exam" "noanswers" "addpoints" "12pt")))
   (TeX-add-to-alist 'LaTeX-provided-package-options
                     '(("inputenc" "utf8")))
   (add-to-list 'LaTeX-verbatim-environments-local "lstlisting")
   (add-to-list 'LaTeX-verbatim-macros-with-braces-local "lstinline")
   (add-to-list 'LaTeX-verbatim-macros-with-braces-local "href")
   (add-to-list 'LaTeX-verbatim-macros-with-braces-local "hyperimage")
   (add-to-list 'LaTeX-verbatim-macros-with-braces-local "hyperbaseurl")
   (add-to-list 'LaTeX-verbatim-macros-with-braces-local "nolinkurl")
   (add-to-list 'LaTeX-verbatim-macros-with-braces-local "url")
   (add-to-list 'LaTeX-verbatim-macros-with-braces-local "path")
   (add-to-list 'LaTeX-verbatim-macros-with-delims-local "lstinline")
   (add-to-list 'LaTeX-verbatim-macros-with-delims-local "path")
   (TeX-run-style-hooks
    "latex2e"
    "exam"
    "exam12"
    "inputenc"
    "booktabs"
    "subcaption"
    "amsmath"
    "amssymb"
    "hyperref"
    "datetime"
    "enumerate"
    "enumitem"
    "xltxtra"
    "listings"
    "graphicx"
    "makecell"
    "multicol"
    "multirow"
    "tabularx"
    "textcomp"
    "tikz"
    "fontspec")
   (TeX-add-symbols
    '("P" 1)
    "Q"
    "R"
    "Z"
    "mathcheckmark"
    "examNumber"
    "semester"
    "className"
    "classNumber"
    "classFullName"))
 :latex)

