package countries;
import tree.Matches;

public class Country implements Comparable<Country>, Matches {
  private final String name;
  private final String continent;

  public Country(String name, String continent) {
    this.name = name;
    this.continent = continent;
  }

  public int compareTo(Country other) {
    return name.compareTo(other.name);
  }

  public String toString() {
    return continent + " | " + name;
  }

  public boolean matches(String theContinent) {
    return continent.equals(theContinent);
  }

}
