package countries;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

import tree.Tree;

public class TreeClient {

  // The queue holding user strings. An instance variable
  // in case it is needed across multiple methods in the object.
  private Tree tree;
  private String fileName;
  /**
   * Default (and only) constructor for a Main (which is an app).
   *
   * Initialize the queue.
   */
  public TreeClient(String fileName) {
    this.fileName = fileName;
    tree = new Tree();
  }

  public void readAFileOfCountries(String fname) {
    try {
      Scanner fin = new Scanner(new File(fname));
      while (fin.hasNextLine()) {
        String line = fin.nextLine();
        if (line.isBlank())
          continue;
        System.out.println(String.format("line: %s", line));

        String parts[] = line.split("\\|");

        tree.add(new Country(parts[1].strip(), parts[0].strip()));
      }
    } catch (FileNotFoundException fnfe) {
      fnfe.printStackTrace();
      System.exit(2);
    }
  }


  /**
   * Load the queue with the commandLoop(), then dumpLeftovers().   *
   */
  public void run() {
    readAFileOfCountries(fileName);
    System.out.println(tree);
    System.out.println(tree.matches("Europe"));
  }

  /**
   * Our standard main: construct a Main, call Main.run
   *
   */
  public static void main(String[] args) {
    TreeClient main = new TreeClient(args[0]);
    main.run();
  }
}
