package tree;

import countries.Country;
public class Tree {

  class TreeNode {
    Country data;
    TreeNode left;
    TreeNode right;

    TreeNode(Country data, TreeNode left, TreeNode right) {
      this.data = data;
      this.left = left;
      this.right = right;
    }

    TreeNode(Country data) {
      this(data, null, null);
    }
  }

  TreeNode root;

  public Tree() {
    root = null;
  }

  public int numberOfNodes() {
    return numberOfNodes(root);
  }

  private int numberOfNodes(TreeNode curr) {
    int retval = 0;
    if (curr != null)
      retval = 1 + numberOfNodes(curr.left) + numberOfNodes(curr.right);
    return retval;
  }

  public int height() {
    return height(root);
  }

  private int height(TreeNode curr) {
    int retval = 0;
    if (curr != null)
      retval = 1 + Math.max(height(curr.left), height(curr.right));
    return retval;
  }

  private TreeNode biggest(TreeNode curr) {
    if (curr == null) return null;
    if (curr.right == null) return curr;
    return biggest(curr.right);
  }

  private TreeNode smallest(TreeNode curr) {
    if (curr == null) return null;
    if (curr.left == null) return curr;
    return smallest(curr.left);
  }

  public void delete(Country victim) {
    root = delete(root, victim);
  }

  private TreeNode delete(TreeNode curr, Country victim) {
    TreeNode retval = curr;
    if (curr == null)
      return null;
    int relation = curr.data.compareTo(victim);
    if (relation > 0) {
      curr.left = delete(curr.left, victim);
    } else if (relation < 0) {
      curr.right = delete(curr.right, victim);
    } else {
      if (curr.right == null)
        retval = curr.left;
      else if (curr.left == null)
        retval = curr.right;
      else {
        TreeNode s = smallest(curr.right);
        curr.data = s.data;
        curr.right = delete(curr.right, s.data);
      }
    }
    return retval;
}

  private TreeNode find(TreeNode curr, Country match) {
    if (curr == null) return null;
    if (curr.data.compareTo(match) == 0) {
      return curr;
    } else if (curr.data.compareTo(match) < 0) {
      return find(curr.right, match);
    } else {
      return find(curr.left, match);
    }
  }

  public void add(Country str) {
    root = add(root, str);
  }
  private TreeNode add(TreeNode curr, Country str) {
    if (curr == null) {
      return new TreeNode(str);
    }
    if (curr.data.compareTo(str) < 0) {
      curr.right = add(curr.right, str);
    } else {
      curr.left = add(curr.left, str);
    }
    return curr;
  }

  private String print(TreeNode curr, String indent) {
    if (curr == null)
      return "";

    String retval;
    retval = print(curr.left, indent + "  ");
    retval += indent + curr.data + "\n";
    retval += print(curr.right, indent + "  ");
    return retval;
  }

  public String toString() {
    return print(root, "");
  }

  private String matches(TreeNode curr, String match) {
    if (curr == null)
      return "";

    String retval;
    retval = matches(curr.left, match);
    if (curr.data.matches(match))
      retval += curr.data + "\n";
    retval += matches(curr.right, match);
    return retval;
  }

  public String matches(String match) {
    return matches(root, match);
  }
}
